/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.Severity;

public class MessageList
implements Serializable,
Iterable<Message> {
    private static final long serialVersionUID = 5518835977871253111L;
    private List<Message> messages = new ArrayList<Message>(0);

    public static final MessageList createCopy(MessageList list, Object oldObject, Object newObject) {
        MessageList newList = new MessageList();
        int numOfMsg = list.getNoOfMessages();
        int i = 0;
        while (i < numOfMsg) {
            newList.add(Message.createCopy(list.getMessage(i), oldObject, newObject));
            ++i;
        }
        return newList;
    }

    public MessageList() {
    }

    public MessageList(Message msg) {
        this.add(msg);
    }

    public void add(Message msg) {
        if (msg == null) {
            throw new NullPointerException();
        }
        this.messages.add(msg);
    }

    public void add(MessageList msgList) {
        if (msgList == null) {
            return;
        }
        int max = msgList.getNoOfMessages();
        int i = 0;
        while (i < max) {
            this.add(msgList.getMessage(i));
            ++i;
        }
    }

    public void add(MessageList msgList, ObjectProperty invalidObjectProperty, boolean override) {
        if (msgList == null) {
            return;
        }
        int max = msgList.getNoOfMessages();
        int i = 0;
        while (i < max) {
            Message msg = msgList.getMessage(i);
            if (override || msg.getInvalidObjectProperties().size() == 0) {
                this.add(new Message(msg.getCode(), msg.getText(), msg.getSeverity(), invalidObjectProperty));
            } else {
                this.add(msg);
            }
            ++i;
        }
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    @Deprecated
    public int getNoOfMessages() {
        return this.size();
    }

    public int size() {
        return this.messages.size();
    }

    public Message getMessage(int index) {
        return this.messages.get(index);
    }

    public Message getFirstMessage(Severity severity) {
        for (Message msg : this.messages) {
            if (msg.getSeverity() != severity) continue;
            return msg;
        }
        return null;
    }

    public Message getMessageByCode(String code) {
        for (Message msg : this.messages) {
            if (!msg.getCode().equals(code)) continue;
            return msg;
        }
        return null;
    }

    public MessageList getMessagesByCode(String code) {
        MessageList sublist = new MessageList();
        if (code == null) {
            return sublist;
        }
        for (Message msg : this.messages) {
            if (!code.equals(msg.getCode())) continue;
            sublist.add(msg);
        }
        return sublist;
    }

    public Severity getSeverity() {
        Severity severity = Severity.NONE;
        for (Message msg : this.messages) {
            if (msg.getSeverity().compareTo(severity) <= 0) continue;
            severity = msg.getSeverity();
        }
        return severity;
    }

    public String getText() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.getNoOfMessages()) {
            if (i > 0) {
                s.append(lineSeparator);
            }
            s.append(this.getMessage(i).getText());
            ++i;
        }
        return s.toString();
    }

    public boolean containsErrorMsg() {
        int i = 0;
        while (i < this.getNoOfMessages()) {
            if (this.getMessage(i).getSeverity() == Severity.ERROR) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public MessageList getMessagesFor(Object object) {
        return this.getMessagesFor(object, null);
    }

    public MessageList getMessagesFor(Object object, String property, int index) {
        MessageList result = new MessageList();
        int i = 0;
        while (i < this.getNoOfMessages()) {
            Message msg = this.getMessage(i);
            List<ObjectProperty> op = msg.getInvalidObjectProperties();
            for (ObjectProperty objectProperty : op) {
                if (!objectProperty.getObject().equals(object)) continue;
                if (property == null) {
                    result.add(msg);
                    break;
                }
                if (!property.equals(objectProperty.getProperty()) || index >= 0 && objectProperty.getIndex() != index) continue;
                result.add(msg);
                break;
            }
            ++i;
        }
        return result;
    }

    public MessageList getMessagesFor(Object object, String property) {
        return this.getMessagesFor(object, property, -1);
    }

    @Override
    public Iterator<Message> iterator() {
        return this.messages.iterator();
    }

    public void clear() {
        this.messages.clear();
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.getNoOfMessages()) {
            s.append(String.valueOf(this.getMessage(i).toString()) + lineSeparator);
            ++i;
        }
        return s.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.messages == null ? 0 : this.messages.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageList other = (MessageList)obj;
        return !(this.messages == null ? other.messages != null : !this.messages.equals(other.messages));
    }
}

