/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.productdataprovider;

import java.io.InputStream;
import org.faktorips.runtime.IVersionChecker;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.toc.CustomTocEntryObject;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.GenerationTocEntry;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.ReadonlyTableOfContents;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.faktorips.runtime.internal.toc.TocEntryObject;
import org.faktorips.runtime.productdataprovider.AbstractProductDataProvider;
import org.faktorips.runtime.productdataprovider.ClassLoaderDataSource;
import org.faktorips.runtime.productdataprovider.DataModifiedException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ClassLoaderProductDataProvider
extends AbstractProductDataProvider {
    private final ClassLoaderDataSource dataSource;
    private final boolean checkTocModifications;
    private final String tocFileLastModified;
    private final ReadonlyTableOfContents toc;
    private final String tocResourcePath;

    public ClassLoaderProductDataProvider(ClassLoaderDataSource dataSource, String tocResourcePath, boolean checkTocModifications) {
        super(new IVersionChecker(){

            @Override
            public boolean isCompatibleVersion(String oldVersion, String newVersion) {
                return oldVersion.equals(newVersion);
            }
        });
        this.dataSource = dataSource;
        this.tocResourcePath = tocResourcePath;
        this.checkTocModifications = checkTocModifications;
        this.toc = this.loadToc();
        this.tocFileLastModified = this.getBaseVersion();
    }

    private ReadonlyTableOfContents loadToc() {
        Element tocElement = this.getDocumentElement(this.tocResourcePath);
        ReadonlyTableOfContents toc = new ReadonlyTableOfContents(this.dataSource.getClassLoader());
        toc.initFromXml(tocElement);
        return toc;
    }

    @Override
    public String getBaseVersion() {
        return this.checkTocModifications ? this.dataSource.getLastModificationStamp(this.tocResourcePath) : this.toc.getProductDataVersion();
    }

    @Override
    public Element getProductCmptData(ProductCmptTocEntry tocEntry) throws DataModifiedException {
        return this.getDocumentElement(tocEntry);
    }

    @Override
    public Element getTestcaseElement(TestCaseTocEntry tocEntry) throws DataModifiedException {
        return this.getDocumentElement(tocEntry);
    }

    private Element getDocumentElement(TocEntryObject tocEntry) throws DataModifiedException {
        String resourcePath = tocEntry.getXmlResourceName();
        Element documentElement = this.getDocumentElement(resourcePath);
        this.throwExceptionIfModified(tocEntry.getIpsObjectId(), this.getBaseVersion());
        return documentElement;
    }

    @Override
    public Element getProductCmptGenerationData(GenerationTocEntry tocEntry) throws DataModifiedException {
        Element docElement = this.getDocumentElement(tocEntry.getParent().getXmlResourceName());
        NodeList nl = docElement.getChildNodes();
        DateTime validFrom = tocEntry.getValidFrom();
        int i = 0;
        while (i < nl.getLength()) {
            Element genElement;
            DateTime generationValidFrom;
            if ("Generation".equals(nl.item(i).getNodeName()) && validFrom.equals(generationValidFrom = DateTime.parseIso((genElement = (Element)nl.item(i)).getAttribute("validFrom")))) {
                this.throwExceptionIfModified(tocEntry.getParent().getIpsObjectId(), this.getBaseVersion());
                return genElement;
            }
            ++i;
        }
        throw new RuntimeException("Can't find the generation for the TOC entry '" + tocEntry + "'");
    }

    @Override
    public InputStream getTableContentAsStream(TableContentTocEntry tocEntry) throws DataModifiedException {
        return this.getResourceAsStream(tocEntry);
    }

    @Override
    public InputStream getEnumContentAsStream(EnumContentTocEntry tocEntry) throws DataModifiedException {
        return this.getResourceAsStream(tocEntry);
    }

    private InputStream getResourceAsStream(TocEntryObject tocEntry) throws DataModifiedException {
        InputStream resourceAsStream = this.dataSource.getResourceAsStream(tocEntry.getXmlResourceName());
        this.throwExceptionIfModified(tocEntry.getIpsObjectId(), this.getBaseVersion());
        return resourceAsStream;
    }

    private Element getDocumentElement(String resourcePath) {
        Document doc = this.dataSource.loadDocument(resourcePath, this.getDocumentBuilder());
        Element element = doc.getDocumentElement();
        if (element == null) {
            throw new RuntimeException("Xml resource '" + resourcePath + "' hasn't got a document element.");
        }
        return element;
    }

    @Override
    public synchronized ReadonlyTableOfContents getToc() {
        return this.toc;
    }

    @Override
    public String getVersion() {
        return this.tocFileLastModified;
    }

    private void throwExceptionIfModified(String name, String timestamp) throws DataModifiedException {
        if (this.checkTocModifications && !this.getVersionChecker().isCompatibleVersion(this.getVersion(), timestamp)) {
            throw new DataModifiedException("Data has changed: " + name, this.getVersion(), timestamp);
        }
    }

    @Override
    public <T> Element getTocEntryData(CustomTocEntryObject<T> tocEntry) throws DataModifiedException {
        return this.getDocumentElement(tocEntry);
    }
}

