/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.model.annotation.IpsConfiguredBy;
import org.faktorips.runtime.model.type.PolicyAssociation;
import org.faktorips.runtime.model.type.PolicyAttribute;
import org.faktorips.runtime.model.type.ProductCmptType;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.model.type.read.PolicyAssociationCollector;
import org.faktorips.runtime.model.type.read.PolicyAttributeCollector;
import org.faktorips.runtime.model.type.read.TypePartsReader;

public class PolicyCmptType
extends Type {
    public static final String KIND_NAME = "PolicyCmptType";
    private final LinkedHashMap<String, PolicyAttribute> attributes;
    private final LinkedHashMap<String, PolicyAssociation> associations;

    public PolicyCmptType(String name, AnnotatedDeclaration annotatedDeclararation) {
        super(name, annotatedDeclararation);
        PolicyAttributeCollector attributeCollector = new PolicyAttributeCollector();
        PolicyAssociationCollector associationCollector = new PolicyAssociationCollector();
        this.initParts(annotatedDeclararation, attributeCollector, associationCollector);
        this.attributes = attributeCollector.createParts(this);
        this.associations = associationCollector.createParts(this);
    }

    private void initParts(AnnotatedDeclaration annotatedDeclararation, PolicyAttributeCollector attributeCollector, PolicyAssociationCollector associationCollector) {
        TypePartsReader typePartsReader = new TypePartsReader(attributeCollector, associationCollector);
        typePartsReader.init(annotatedDeclararation);
        typePartsReader.read(annotatedDeclararation);
    }

    @Override
    protected String getKindName() {
        return KIND_NAME;
    }

    public boolean isConfiguredByProductCmptType() {
        return this.getAnnotatedDeclaration().is(IpsConfiguredBy.class);
    }

    public ProductCmptType getProductCmptType() {
        return IpsModel.getProductCmptType(this.getAnnotatedDeclaration().get(IpsConfiguredBy.class).value().asSubclass(IProductComponent.class));
    }

    @Override
    public PolicyCmptType getSuperType() {
        Class<?> superclass = this.getJavaClass().getSuperclass();
        return IpsModel.isPolicyCmptType(superclass) ? IpsModel.getPolicyCmptType(superclass.asSubclass(IModelObject.class)) : null;
    }

    @Override
    public PolicyAttribute getDeclaredAttribute(String name) {
        PolicyAttribute attr = this.attributes.get(name);
        if (attr == null) {
            throw new IllegalArgumentException("The type " + this + " hasn't got a declared attribute " + name);
        }
        return attr;
    }

    @Override
    public PolicyAttribute getDeclaredAttribute(int index) {
        return (PolicyAttribute)super.getDeclaredAttribute(index);
    }

    public List<PolicyAttribute> getDeclaredAttributes() {
        return new ArrayList<PolicyAttribute>(this.attributes.values());
    }

    @Override
    public PolicyAttribute getAttribute(String name) {
        return (PolicyAttribute)super.getAttribute(name);
    }

    public List<PolicyAttribute> getAttributes() {
        Type.AttributeCollector attrCollector = new Type.AttributeCollector();
        attrCollector.visitHierarchy(this);
        return attrCollector.getResult();
    }

    @Override
    public PolicyAssociation getDeclaredAssociation(String name) {
        return this.associations.get(name);
    }

    @Override
    public PolicyAssociation getDeclaredAssociation(int index) {
        return (PolicyAssociation)super.getDeclaredAssociation(index);
    }

    public List<PolicyAssociation> getDeclaredAssociations() {
        return new ArrayList<PolicyAssociation>(new LinkedHashSet<PolicyAssociation>(this.associations.values()));
    }

    @Override
    public PolicyAssociation getAssociation(String name) {
        return (PolicyAssociation)super.getAssociation(name);
    }

    public List<PolicyAssociation> getAssociations() {
        Type.AssociationsCollector asscCollector = new Type.AssociationsCollector();
        asscCollector.visitHierarchy(this);
        return asscCollector.getResult();
    }
}

