/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.util.HashMap;
import java.util.Map;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.ITable;
import org.faktorips.runtime.caching.IComputable;
import org.faktorips.runtime.caching.Memoizer;
import org.faktorips.runtime.internal.AbstractCacheFactory;

public class DefaultCacheFactory
extends AbstractCacheFactory {
    private Map<Class<?>, Integer> initialSizeMap = new HashMap();
    private int defaultInitialSize = 100;
    private float laodFactor = 0.75f;
    private int concurrencyLevel = 16;

    public DefaultCacheFactory(ClassLoader cl) {
        this(cl, 500, 5000, 100, 100, 100);
    }

    @Deprecated
    public DefaultCacheFactory(ClassLoader cl, int initialCapacityForProductCmpts, int initialCapacityForProductCmptGenerations, int initialCapacityForTablesByClassname, int initialCapacityForTablesByQname, int initialCapacityForEnumContentByClassName) {
        try {
            this.setInitialSize(cl.loadClass(IProductComponent.class.getName()), initialCapacityForProductCmpts);
            this.setInitialSize(cl.loadClass(IProductComponentGeneration.class.getName()), initialCapacityForProductCmptGenerations);
            this.setInitialSize(cl.loadClass(ITable.class.getName()), initialCapacityForTablesByClassname);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void setInitialSize(Class<?> typeClass, int size) {
        this.initialSizeMap.put(typeClass, size);
    }

    public void setDefaultInitialSize(int defaultInitialSize) {
        this.defaultInitialSize = defaultInitialSize;
    }

    protected int getInitialSize(Class<?> typeClass) {
        Integer initSize = this.initialSizeMap.get(typeClass);
        if (initSize == null) {
            initSize = this.defaultInitialSize;
        }
        return initSize;
    }

    public <K, V> Memoizer<K, V> createCache(IComputable<K, V> computable) {
        Integer initSize = this.initialSizeMap.get(computable.getValueClass());
        if (initSize == null) {
            initSize = this.defaultInitialSize;
        }
        return new Memoizer<K, V>(computable, initSize, this.laodFactor, this.concurrencyLevel);
    }

    public void setConcurrencyLevel(int concurrencyLevel) {
        this.concurrencyLevel = concurrencyLevel;
    }

    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }
}

