/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.faktorips.runtime.IObjectReferenceStore;
import org.faktorips.runtime.IUnresolvedReference;

public class DefaultObjectReferenceStore
implements IObjectReferenceStore {
    private Map<Object, List<Object>> objects = new HashMap<Object, List<Object>>(100);
    private List<IUnresolvedReference> references = new ArrayList<IUnresolvedReference>();

    @Override
    public void resolveReferences() throws Exception {
        for (IUnresolvedReference ref : this.references) {
            ref.resolve(this);
        }
    }

    @Override
    public void putObject(Object id, Object object) {
        List<Object> list = this.objects.get(id);
        if (list == null) {
            list = new ArrayList<Object>(1);
            this.objects.put(id, list);
        }
        if (!list.contains(object)) {
            list.add(object);
        }
    }

    @Override
    public void addUnresolvedReference(IUnresolvedReference reference) {
        this.references.add(reference);
    }

    @Override
    public Object getObject(Class<?> clazz, Object id) {
        List<Object> objectsWithId = this.objects.get(id);
        if (objectsWithId == null) {
            return null;
        }
        for (Object obj : objectsWithId) {
            if (!clazz.isAssignableFrom(obj.getClass())) continue;
            return obj;
        }
        return null;
    }

    @Override
    public Collection<List<Object>> getAllObjects() {
        return this.objects.values();
    }

    @Override
    public Collection<IUnresolvedReference> getAllUnresolvedReferences() {
        return this.references;
    }
}

