/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime;

import java.io.Serializable;
import org.faktorips.runtime.IPropertyQualifier;
import org.faktorips.values.ObjectUtil;

public class ObjectProperty
implements Serializable {
    private static final long serialVersionUID = -3407760096164658253L;
    private final Object object;
    private final String property;
    private final int index;
    private final int hashCode;
    private final IPropertyQualifier qualifier;

    public ObjectProperty(Object object, String property, int index, IPropertyQualifier qualifier) {
        this.object = object;
        this.property = property;
        this.index = index;
        this.qualifier = qualifier;
        this.hashCode = this.createHashCode();
    }

    public ObjectProperty(Object object, String property, IPropertyQualifier qualifier) {
        this(object, property, -1, qualifier);
    }

    public ObjectProperty(Object object, String property, int index) {
        this(object, property, index, null);
    }

    public ObjectProperty(Object object, String property) {
        this(object, property, -1);
    }

    public ObjectProperty(Object object) {
        this(object, null, -1);
    }

    private int createHashCode() {
        int hash = this.object.hashCode() + this.index;
        hash = this.property == null ? hash : 31 * hash + this.property.hashCode();
        hash = this.qualifier == null ? hash : 31 * hash + this.qualifier.hashCode();
        return hash;
    }

    public Object getObject() {
        return this.object;
    }

    public String getProperty() {
        return this.property;
    }

    public int getIndex() {
        return this.index;
    }

    public IPropertyQualifier getQualifier() {
        return this.qualifier;
    }

    public boolean hasIndex() {
        return this.index >= 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectProperty) {
            ObjectProperty other = (ObjectProperty)obj;
            return ObjectUtil.equals((Object)this.object, (Object)other.object) && this.index == other.index && ObjectUtil.equals((Object)this.property, (Object)other.property) && ObjectUtil.equals((Object)this.qualifier, (Object)other.qualifier);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.object)) + "." + this.property;
    }
}

