/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.formula;

import java.util.ArrayList;
import java.util.List;
import org.faktorips.annotation.UtilityClass;
import org.faktorips.runtime.IConfigurableModelObject;
import org.faktorips.runtime.IModelObject;

@UtilityClass
public enum FormulaEvaluatorUtil {


    public static <T extends IModelObject, R extends T> R getModelObjectById(List<? extends T> modelObjects, String id) {
        for (IModelObject modelObject : modelObjects) {
            if (!(modelObject instanceof IConfigurableModelObject) || !((IConfigurableModelObject)modelObject).getProductComponent().getId().equals(id)) continue;
            IModelObject castedModelObject = modelObject;
            return (R)castedModelObject;
        }
        return null;
    }

    public static <T extends IModelObject, R extends T> List<? extends R> getListModelObjectById(List<? extends T> modelObjects, String id) {
        ArrayList<IModelObject> returnList = new ArrayList<IModelObject>();
        for (IModelObject modelObject : modelObjects) {
            if (!(modelObject instanceof IConfigurableModelObject) || !((IConfigurableModelObject)modelObject).getProductComponent().getId().equals(id)) continue;
            IModelObject castedModelObject = modelObject;
            returnList.add(castedModelObject);
        }
        return returnList;
    }

    public static <T extends IModelObject, R extends T> R getModelObjectById(T modelObject, String id) {
        if (modelObject instanceof IConfigurableModelObject && ((IConfigurableModelObject)modelObject).getProductComponent().getId().equals(id)) {
            T castedModelObject = modelObject;
            return (R)castedModelObject;
        }
        return null;
    }

    public static abstract class AssociationTo1Helper<S extends IModelObject, T extends IModelObject> {
        public List<? extends T> getTargets(List<? extends S> sourceObjects) {
            ArrayList<T> targets = new ArrayList<T>();
            for (IModelObject sourceObject : sourceObjects) {
                T target = this.getTargetInternal(sourceObject);
                if (targets.contains(target)) continue;
                targets.add(target);
            }
            return targets;
        }

        protected abstract T getTargetInternal(S var1);
    }

    public static abstract class AssociationToManyHelper<S extends IModelObject, T extends IModelObject> {
        public List<? extends T> getTargets(List<? extends S> sourceObjects) {
            ArrayList<IModelObject> targets = new ArrayList<IModelObject>();
            for (IModelObject sourceObject : sourceObjects) {
                List<T> foundTargets = this.getTargetsInternal(sourceObject);
                for (IModelObject target : foundTargets) {
                    if (targets.contains(target)) continue;
                    targets.add(target);
                }
            }
            return targets;
        }

        protected abstract List<? extends T> getTargetsInternal(S var1);
    }

    public static abstract class AttributeAccessorHelper<S extends IModelObject, E> {
        public List<E> getAttributeValues(List<? extends S> objectList) {
            ArrayList<E> values = new ArrayList<E>();
            for (IModelObject object : objectList) {
                values.add(this.getValueInternal(object));
            }
            return values;
        }

        protected abstract E getValueInternal(S var1);
    }

    public static abstract class ExistsHelper {
        public boolean exists() {
            try {
                return this.existsInternal();
            }
            catch (Exception e) {
                return false;
            }
        }

        protected abstract boolean existsInternal();
    }

    public static abstract class FunctionWithListAsArgumentHelper<E> {
        public E getResult(List<E> listOfValues) {
            if (listOfValues == null || listOfValues.isEmpty()) {
                return this.getFallBackValue();
            }
            E result = listOfValues.get(0);
            int i = 1;
            while (i < listOfValues.size()) {
                result = this.getPreliminaryResult(result, listOfValues.get(i));
                ++i;
            }
            return result;
        }

        public abstract E getFallBackValue();

        public abstract E getPreliminaryResult(E var1, E var2);
    }
}

