/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.tableindex;

import java.util.Map;
import java.util.TreeMap;

public enum RangeType {
    LOWER_BOUND{

        @Override
        public <K extends Comparable<? super K>, V> V getValue(TreeMap<K, V> tree, K key) {
            Map.Entry<K, V> floorEntry = tree.floorEntry(key);
            if (floorEntry == null) {
                return null;
            }
            return (V)RangeType.getLowerValueIfNeccessary(tree, key, floorEntry);
        }
    }
    ,
    LOWER_BOUND_EQUAL{

        @Override
        public <K extends Comparable<? super K>, V> V getValue(TreeMap<K, V> tree, K key) {
            Map.Entry<K, V> floorEntry = tree.floorEntry(key);
            return (V)RangeType.getValueOrNull(floorEntry);
        }
    }
    ,
    UPPER_BOUND{

        @Override
        public <K extends Comparable<? super K>, V> V getValue(TreeMap<K, V> tree, K key) {
            Map.Entry<K, V> ceilingEntry = tree.ceilingEntry(key);
            if (ceilingEntry == null) {
                return null;
            }
            return (V)RangeType.getHigherValueIfNeccessary(tree, key, ceilingEntry);
        }
    }
    ,
    UPPER_BOUND_EQUAL{

        @Override
        public <K extends Comparable<? super K>, V> V getValue(TreeMap<K, V> tree, K key) {
            Map.Entry<K, V> ceilingEntry = tree.ceilingEntry(key);
            return (V)RangeType.getValueOrNull(ceilingEntry);
        }
    };


    private RangeType() {
    }

    public abstract <K extends Comparable<? super K>, V> V getValue(TreeMap<K, V> var1, K var2);

    private static <K extends Comparable<? super K>, V> V getLowerValueIfNeccessary(TreeMap<K, V> tree, K key, Map.Entry<K, V> floorEntry) {
        if (((Comparable)floorEntry.getKey()).compareTo(key) < 0) {
            return floorEntry.getValue();
        }
        Map.Entry<Comparable, V> lowerEntry = tree.lowerEntry((Comparable)floorEntry.getKey());
        return RangeType.getValueOrNull(lowerEntry);
    }

    private static <K extends Comparable<? super K>, V> V getHigherValueIfNeccessary(TreeMap<K, V> tree, K key, Map.Entry<K, V> ceilingEntry) {
        if (((Comparable)ceilingEntry.getKey()).compareTo(key) > 0) {
            return ceilingEntry.getValue();
        }
        Map.Entry<Comparable, V> higherEntry = tree.higherEntry((Comparable)ceilingEntry.getKey());
        return RangeType.getValueOrNull(higherEntry);
    }

    private static <K, V> V getValueOrNull(Map.Entry<K, V> entry) {
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    /* synthetic */ RangeType(String string, int n, RangeType rangeType) {
        this();
    }
}

