/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.toc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.EnumXmlAdapterTocEntry;
import org.faktorips.runtime.internal.toc.FormulaTestTocEntry;
import org.faktorips.runtime.internal.toc.GenerationTocEntry;
import org.faktorips.runtime.internal.toc.ITocEntryFactory;
import org.faktorips.runtime.internal.toc.PolicyCmptTypeTocEntry;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.ProductCmptTypeTocEntry;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.faktorips.runtime.internal.toc.TocEntryObject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractTocEntryFactory<T extends TocEntryObject>
implements ITocEntryFactory<T> {
    @Override
    public T createFromXml(Element entryElement) {
        String ipsObjectId = entryElement.getAttribute("ipsObjectId");
        String ipsObjectQualifiedName = entryElement.getAttribute("ipsObjectQualifiedName");
        String xmlResourceName = entryElement.getAttribute("xmlResource");
        if (xmlResourceName == null) {
            xmlResourceName = "";
        }
        String implementationClassName = entryElement.getAttribute("implementationClass");
        return this.createFromXmlInternal(entryElement, ipsObjectId, ipsObjectQualifiedName, xmlResourceName, implementationClassName);
    }

    abstract T createFromXmlInternal(Element var1, String var2, String var3, String var4, String var5);

    public static Set<ITocEntryFactory<?>> getBaseTocEntryFactories() {
        HashSet set = new HashSet();
        set.add(new ProductCmptTocEntryFactory());
        set.add(new TableContentTocEntryFactory());
        set.add(new TestCaseTocEntryFactory());
        set.add(new EnumContentTocEntryFactory());
        set.add(new EnumXmlAdapterTocEntryFactory());
        set.add(new FormulaTestTocEntryFactory());
        set.add(new ProductCmptTypeTocEntryFactory());
        set.add(new PolicyCmptTypeTocEntryFactory());
        return set;
    }

    public static class EnumContentTocEntryFactory
    extends AbstractTocEntryFactory<EnumContentTocEntry> {
        @Override
        EnumContentTocEntry createFromXmlInternal(Element entryElement, String ipsObjectId, String ipsObjectQualifiedName, String xmlResourceName, String implementationClassName) {
            return new EnumContentTocEntry(ipsObjectId, ipsObjectQualifiedName, xmlResourceName, implementationClassName);
        }

        @Override
        public String getXmlTag() {
            return "EnumContent";
        }
    }

    public static class EnumXmlAdapterTocEntryFactory
    extends AbstractTocEntryFactory<EnumXmlAdapterTocEntry> {
        @Override
        EnumXmlAdapterTocEntry createFromXmlInternal(Element entryElement, String ipsObjectId, String ipsObjectQualifiedName, String xmlResourceName, String implementationClassName) {
            return new EnumXmlAdapterTocEntry(ipsObjectId, ipsObjectQualifiedName, implementationClassName);
        }

        @Override
        public String getXmlTag() {
            return "EnumXmlAdapter";
        }
    }

    public static class FormulaTestTocEntryFactory
    extends AbstractTocEntryFactory<FormulaTestTocEntry> {
        @Override
        FormulaTestTocEntry createFromXmlInternal(Element entryElement, String ipsObjectId, String ipsObjectQualifiedName, String xmlResourceName, String implementationClassName) {
            String kindId = entryElement.getAttribute("kindId");
            String versionId = entryElement.getAttribute("versionId");
            return new FormulaTestTocEntry(ipsObjectId, ipsObjectQualifiedName, kindId, versionId, implementationClassName);
        }

        @Override
        public String getXmlTag() {
            return "FormulaTest";
        }
    }

    public static class PolicyCmptTypeTocEntryFactory
    extends AbstractTocEntryFactory<PolicyCmptTypeTocEntry> {
        @Override
        PolicyCmptTypeTocEntry createFromXmlInternal(Element entryElement, String ipsObjectId, String ipsObjectQualifiedName, String xmlResourceName, String implementationClassName) {
            return new PolicyCmptTypeTocEntry(ipsObjectId, ipsObjectQualifiedName, implementationClassName);
        }

        @Override
        public String getXmlTag() {
            return "PolicyCmptType";
        }
    }

    public static class ProductCmptTocEntryFactory
    extends AbstractTocEntryFactory<ProductCmptTocEntry> {
        @Override
        ProductCmptTocEntry createFromXmlInternal(Element entryElement, String ipsObjectId, String ipsObjectQualifiedName, String xmlResourceName, String implementationClassName) {
            String generationImplClassName = entryElement.getAttribute("generationImplClassName");
            DateTime validTo = DateTime.parseIso(entryElement.getAttribute("validTo"));
            String kindId = entryElement.getAttribute("kindId");
            String versionId = entryElement.getAttribute("versionId");
            ProductCmptTocEntry newEntry = new ProductCmptTocEntry(ipsObjectId, ipsObjectQualifiedName, kindId, versionId, xmlResourceName, implementationClassName, generationImplClassName, validTo);
            NodeList nl = entryElement.getElementsByTagName("Generation");
            ArrayList<GenerationTocEntry> generationEntries = new ArrayList<GenerationTocEntry>(nl.getLength());
            int i = 0;
            while (i < nl.getLength()) {
                GenerationTocEntry entry = GenerationTocEntry.createFromXml(newEntry, (Element)nl.item(i));
                generationEntries.add(entry);
                ++i;
            }
            newEntry.setGenerationEntries(generationEntries);
            return newEntry;
        }

        @Override
        public String getXmlTag() {
            return "ProductComponent";
        }
    }

    public static class ProductCmptTypeTocEntryFactory
    extends AbstractTocEntryFactory<ProductCmptTypeTocEntry> {
        @Override
        ProductCmptTypeTocEntry createFromXmlInternal(Element entryElement, String ipsObjectId, String ipsObjectQualifiedName, String xmlResourceName, String implementationClassName) {
            return new ProductCmptTypeTocEntry(ipsObjectId, ipsObjectQualifiedName, implementationClassName);
        }

        @Override
        public String getXmlTag() {
            return "ProductCmptType";
        }
    }

    public static class TableContentTocEntryFactory
    extends AbstractTocEntryFactory<TableContentTocEntry> {
        @Override
        TableContentTocEntry createFromXmlInternal(Element entryElement, String ipsObjectId, String ipsObjectQualifiedName, String xmlResourceName, String implementationClassName) {
            return new TableContentTocEntry(ipsObjectId, ipsObjectQualifiedName, xmlResourceName, implementationClassName);
        }

        @Override
        public String getXmlTag() {
            return "TableContent";
        }
    }

    public static class TestCaseTocEntryFactory
    extends AbstractTocEntryFactory<TestCaseTocEntry> {
        @Override
        TestCaseTocEntry createFromXmlInternal(Element entryElement, String ipsObjectId, String ipsObjectQualifiedName, String xmlResourceName, String implementationClassName) {
            return new TestCaseTocEntry(ipsObjectId, ipsObjectQualifiedName, xmlResourceName, implementationClassName);
        }

        @Override
        public String getXmlTag() {
            return "TestCase";
        }
    }
}

