/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.toc;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import org.faktorips.runtime.internal.DateTime;
import org.faktorips.runtime.internal.toc.GenerationTocEntry;
import org.faktorips.runtime.internal.toc.TocEntryObject;
import org.w3c.dom.Element;

public class ProductCmptTocEntry
extends TocEntryObject {
    public static final String PROPERTY_KIND_ID = "kindId";
    public static final String PROPERTY_VERSION_ID = "versionId";
    public static final String PROPERTY_VALID_TO = "validTo";
    public static final String PROPERTY_GENERATION_IMPL_CLASS_NAME = "generationImplClassName";
    public static final String XML_TAG = "ProductComponent";
    private TreeMap<Long, GenerationTocEntry> generationEntries = ProductCmptTocEntry.createNewTreeMap();
    private final String kindId;
    private final String versionId;
    private final DateTime validTo;
    private final String generationImplClassName;

    public ProductCmptTocEntry(String ipsObjectId, String ipsObjectQualifiedName, String kindId, String versionId, String xmlResourceName, String implementationClassName, String generationImplClassName, DateTime validTo) {
        super(ipsObjectId, ipsObjectQualifiedName, xmlResourceName, implementationClassName);
        this.kindId = kindId;
        this.versionId = versionId;
        this.validTo = validTo;
        this.generationImplClassName = generationImplClassName;
    }

    public String getKindId() {
        return this.kindId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public DateTime getValidTo() {
        return this.validTo;
    }

    public List<GenerationTocEntry> getGenerationEntries() {
        return new ArrayList<GenerationTocEntry>(this.generationEntries.values());
    }

    public int getNumberOfGenerationEntries() {
        return this.generationEntries == null ? 0 : this.generationEntries.size();
    }

    public String getGenerationImplClassName() {
        return this.generationImplClassName;
    }

    public void setGenerationEntries(List<GenerationTocEntry> entries) {
        this.generationEntries = ProductCmptTocEntry.createNewTreeMap();
        for (GenerationTocEntry entry : entries) {
            this.generationEntries.put(entry.getValidFromInMillisec(TimeZone.getDefault()), entry);
        }
    }

    public GenerationTocEntry getNextGenerationEntry(Calendar validFrom) {
        SortedMap<Long, GenerationTocEntry> map = this.generationEntries.headMap(validFrom.getTimeInMillis());
        if (map.isEmpty()) {
            return null;
        }
        Long key = map.lastKey();
        return this.generationEntries.get(key);
    }

    public GenerationTocEntry getPreviousGenerationEntry(Calendar validFrom) {
        SortedMap<Long, GenerationTocEntry> map = this.generationEntries.tailMap(validFrom.getTimeInMillis() - 1L);
        if (map.isEmpty()) {
            return null;
        }
        Long key = map.firstKey();
        return this.generationEntries.get(key);
    }

    public GenerationTocEntry getLatestGenerationEntry() {
        if (this.generationEntries.isEmpty()) {
            return null;
        }
        return this.generationEntries.get(this.generationEntries.firstKey());
    }

    public GenerationTocEntry getGenerationEntry(Calendar effectiveDate) {
        if (effectiveDate == null) {
            return null;
        }
        SortedMap<Long, GenerationTocEntry> map = this.generationEntries.tailMap(effectiveDate.getTimeInMillis() + 1L);
        if (map.isEmpty()) {
            return null;
        }
        Long key = map.firstKey();
        return this.generationEntries.get(key);
    }

    public GenerationTocEntry getGenerationEntry(DateTime validAt) {
        return this.generationEntries.get(validAt.toTimeInMillisecs(TimeZone.getDefault()));
    }

    @Override
    protected void addToXml(Element entryElement) {
        super.addToXml(entryElement);
        entryElement.setAttribute(PROPERTY_KIND_ID, this.kindId);
        entryElement.setAttribute(PROPERTY_VERSION_ID, this.versionId);
        if (this.validTo != null) {
            entryElement.setAttribute(PROPERTY_VALID_TO, this.validTo.toIsoFormat());
        }
        if (!this.getGenerationEntries().isEmpty()) {
            entryElement.setAttribute(PROPERTY_GENERATION_IMPL_CLASS_NAME, this.generationImplClassName);
            for (GenerationTocEntry generationEntry : this.generationEntries.values()) {
                entryElement.appendChild(generationEntry.toXml(entryElement.getOwnerDocument()));
            }
        }
    }

    @Override
    protected String getXmlElementTag() {
        return XML_TAG;
    }

    private static TreeMap<Long, GenerationTocEntry> createNewTreeMap() {
        return new TreeMap<Long, GenerationTocEntry>(new InverseLongComparator());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.generationEntries == null ? 0 : this.generationEntries.size());
        result = 31 * result + (this.generationImplClassName == null ? 0 : this.generationImplClassName.hashCode());
        result = 31 * result + (this.kindId == null ? 0 : this.kindId.hashCode());
        result = 31 * result + (this.validTo == null ? 0 : this.validTo.hashCode());
        result = 31 * result + (this.versionId == null ? 0 : this.versionId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ProductCmptTocEntry)) {
            return false;
        }
        ProductCmptTocEntry other = (ProductCmptTocEntry)obj;
        if (this.generationEntries == null ? other.generationEntries != null : !this.generationEntries.equals(other.generationEntries)) {
            return false;
        }
        if (this.generationImplClassName == null ? other.generationImplClassName != null : !this.generationImplClassName.equals(other.generationImplClassName)) {
            return false;
        }
        if (this.kindId == null ? other.kindId != null : !this.kindId.equals(other.kindId)) {
            return false;
        }
        if (this.validTo == null ? other.validTo != null : !this.validTo.equals(other.validTo)) {
            return false;
        }
        if (this.versionId == null ? other.versionId != null : !this.versionId.equals(other.versionId)) {
            return false;
        }
        return super.equals(obj);
    }

    static class InverseLongComparator
    implements Comparator<Long> {
        InverseLongComparator() {
        }

        @Override
        public int compare(Long first, Long second) {
            return -1 * first.compareTo(second);
        }
    }
}

