/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.faktorips.runtime.caching.AbstractComputable;
import org.faktorips.runtime.caching.Memoizer;
import org.faktorips.runtime.model.annotation.IpsPublishedInterface;

public class AnnotatedDeclaration {
    private static final Memoizer<Class<?>, AnnotatedDeclaration> ANNOTATED_TYPE_CACHE = new Memoizer(new AbstractComputable<Class<?>, AnnotatedDeclaration>(AnnotatedDeclaration.class){

        @Override
        public AnnotatedDeclaration compute(Class<?> productComponentClass) {
            return new AnnotatedDeclaration(productComponentClass, null);
        }
    });
    private final List<Class<?>> annotatedClasses = new ArrayList();

    private AnnotatedDeclaration(Class<?> modelClass) {
        this.add(AnnotatedDeclaration.getPublishedInterface(modelClass));
        this.add(AnnotatedDeclaration.getImplementationClass(modelClass));
    }

    private void add(Class<?> annotatedClass) {
        if (annotatedClass != null) {
            this.annotatedClasses.add(annotatedClass);
        }
    }

    public static AnnotatedDeclaration from(Class<?> generatedClass) {
        try {
            return ANNOTATED_TYPE_CACHE.compute(generatedClass);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public boolean is(Class<? extends Annotation> annotationClass) {
        for (Class<?> annotatedClass : this.annotatedClasses) {
            if (!annotatedClass.isAnnotationPresent(annotationClass)) continue;
            return true;
        }
        return false;
    }

    public <T extends Annotation> T get(Class<T> annotationClass) {
        for (Class<?> annotatedClass : this.annotatedClasses) {
            if (!annotatedClass.isAnnotationPresent(annotationClass)) continue;
            return annotatedClass.getAnnotation(annotationClass);
        }
        return null;
    }

    public List<Field> getDeclaredFields() {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class<?> annotatedClass : this.annotatedClasses) {
            result.addAll(Arrays.asList(annotatedClass.getDeclaredFields()));
        }
        return result;
    }

    public List<Method> getDeclaredMethods() {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> annotatedClass : this.annotatedClasses) {
            result.addAll(Arrays.asList(annotatedClass.getDeclaredMethods()));
        }
        return result;
    }

    public List<AnnotatedElement> getDeclaredElements() {
        ArrayList<AnnotatedElement> result = new ArrayList<AnnotatedElement>();
        result.addAll(this.getDeclaredFields());
        result.addAll(this.getDeclaredMethods());
        return result;
    }

    public ClassLoader getClassLoader() {
        return this.annotatedClasses.get(0).getClassLoader();
    }

    public Class<?> getImplementationClass() {
        return AnnotatedDeclaration.getImplementationClass(this.annotatedClasses.get(0));
    }

    public Class<?> getPublishedInterface() {
        return AnnotatedDeclaration.getPublishedInterface(this.annotatedClasses.get(0));
    }

    public String getDeclarationClassName() {
        return this.getPublishedInterface() != null ? this.getPublishedInterface().getCanonicalName() : this.getImplementationClass().getCanonicalName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotatedClasses == null ? 0 : this.annotatedClasses.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotatedDeclaration other = (AnnotatedDeclaration)obj;
        return !(this.annotatedClasses == null ? other.annotatedClasses != null : !this.annotatedClasses.equals(other.annotatedClasses));
    }

    static Class<?> getPublishedInterface(Class<?> modelObjectClass) {
        Class<?>[] interfaces;
        if (modelObjectClass.isInterface()) {
            return modelObjectClass;
        }
        Class<?>[] classArray = interfaces = modelObjectClass.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            if (iface.isAnnotationPresent(IpsPublishedInterface.class)) {
                return iface;
            }
            ++n2;
        }
        return null;
    }

    static Class<?> getImplementationClass(Class<?> modelObjectClass) {
        if (modelObjectClass.isInterface()) {
            if (modelObjectClass.isAnnotationPresent(IpsPublishedInterface.class)) {
                return modelObjectClass.getAnnotation(IpsPublishedInterface.class).implementation();
            }
            return null;
        }
        return modelObjectClass;
    }

    /* synthetic */ AnnotatedDeclaration(Class clazz, AnnotatedDeclaration annotatedDeclaration) {
        this(clazz);
    }
}

