/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type.read;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.faktorips.runtime.IProductComponentGeneration;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.model.annotation.IpsTableUsage;
import org.faktorips.runtime.model.annotation.IpsTableUsages;
import org.faktorips.runtime.model.type.ModelElement;
import org.faktorips.runtime.model.type.TableUsage;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.model.type.read.AnnotationProcessor;
import org.faktorips.runtime.model.type.read.PartDescriptor;
import org.faktorips.runtime.model.type.read.TypePartCollector;

public class TableUsageCollector
extends TypePartCollector<TableUsage, TableUsageDescriptor> {
    public TableUsageCollector() {
        super(Arrays.asList(new TableUsageProcessor()));
    }

    @Override
    protected TableUsageDescriptor createDescriptor() {
        return new TableUsageDescriptor();
    }

    @Override
    protected String[] getNames(AnnotatedDeclaration annotatedDeclaration) {
        if (annotatedDeclaration.is(IpsTableUsages.class)) {
            return annotatedDeclaration.get(IpsTableUsages.class).value();
        }
        return NO_NAMES;
    }

    static class TableUsageDescriptor
    extends PartDescriptor<TableUsage> {
        private boolean changingOverTime;
        private Method annotatedElement;

        TableUsageDescriptor() {
        }

        public boolean isValid() {
            return this.getAnnotatedElement() != null;
        }

        public Method getAnnotatedElement() {
            return this.annotatedElement;
        }

        public void setAnnotatedElement(Method annotatedElement) {
            this.annotatedElement = annotatedElement;
        }

        public boolean isChangingOverTime() {
            return this.changingOverTime;
        }

        public void setChangingOverTime(boolean changingOverTime) {
            this.changingOverTime = changingOverTime;
        }

        @Override
        public TableUsage create(ModelElement parentElement) {
            Type type = (Type)parentElement;
            if (this.isValid()) {
                return this.createValid(type);
            }
            throw new IllegalArgumentException(type.getDeclarationClass() + " lists \"" + this.getName() + "\" as one of it's @IpsTableUsages but no matching @IpsTableUsage could be found.");
        }

        private TableUsage createValid(Type type) {
            return new TableUsage(type, this.getAnnotatedElement());
        }
    }

    static class TableUsageProcessor
    extends AnnotationProcessor<IpsTableUsage, TableUsageDescriptor> {
        public TableUsageProcessor() {
            super(IpsTableUsage.class);
        }

        @Override
        public String getName(IpsTableUsage annotation) {
            return annotation.name();
        }

        @Override
        public void process(TableUsageDescriptor descriptor, AnnotatedDeclaration annotatedDeclaration, AnnotatedElement annotatedElement) {
            descriptor.setAnnotatedElement((Method)annotatedElement);
            descriptor.setChangingOverTime(IProductComponentGeneration.class.isAssignableFrom(annotatedDeclaration.getImplementationClass()));
        }
    }
}

