/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.toc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.faktorips.runtime.IRuntimeObject;
import org.faktorips.runtime.internal.toc.AbstractReadonlyTableOfContents;
import org.faktorips.runtime.internal.toc.CustomTocEntryObject;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.EnumXmlAdapterTocEntry;
import org.faktorips.runtime.internal.toc.FormulaTestTocEntry;
import org.faktorips.runtime.internal.toc.ModelTypeTocEntry;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.faktorips.runtime.internal.toc.TocEntryObject;
import org.w3c.dom.Element;

public class ReadonlyTableOfContents
extends AbstractReadonlyTableOfContents {
    private Map<String, ProductCmptTocEntry> pcIdTocEntryMap;
    private Map<String, ProductCmptTocEntry> pcNameTocEntryMap;
    private Map<String, List<VersionIdTocEntry>> kindIdTocEntryListMap;
    private Map<String, TableContentTocEntry> tableImplClassTocEntryMap;
    private Map<String, TableContentTocEntry> tableContentNameTocEntryMap;
    private Map<String, TestCaseTocEntry> testCaseNameTocEntryMap;
    private Map<String, ModelTypeTocEntry> modelTypeNameTocEntryMap;
    private Map<String, EnumContentTocEntry> enumContentImplClassTocEntryMap;
    private Map<String, EnumXmlAdapterTocEntry> enumXmlAdapterTocEntryMap;
    private Map<Class<?>, Map<String, CustomTocEntryObject<?>>> otherTocEntryMaps;

    public ReadonlyTableOfContents() {
        super(ReadonlyTableOfContents.class.getClassLoader());
    }

    public ReadonlyTableOfContents(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    public void initFromXml(Element tocElement) {
        int size = tocElement.getChildNodes().getLength();
        this.initHashMaps(size);
        super.initFromXml(tocElement);
    }

    protected void initHashMaps(int tocSize) {
        this.pcIdTocEntryMap = new HashMap<String, ProductCmptTocEntry>(tocSize);
        this.pcNameTocEntryMap = new HashMap<String, ProductCmptTocEntry>(tocSize);
        this.kindIdTocEntryListMap = new HashMap<String, List<VersionIdTocEntry>>(tocSize);
        this.tableImplClassTocEntryMap = new HashMap<String, TableContentTocEntry>(tocSize / 4);
        this.tableContentNameTocEntryMap = new HashMap<String, TableContentTocEntry>(tocSize / 4);
        this.testCaseNameTocEntryMap = new HashMap<String, TestCaseTocEntry>();
        this.modelTypeNameTocEntryMap = new HashMap<String, ModelTypeTocEntry>(tocSize / 4);
        this.enumContentImplClassTocEntryMap = new HashMap<String, EnumContentTocEntry>(tocSize / 4);
        this.enumXmlAdapterTocEntryMap = new HashMap<String, EnumXmlAdapterTocEntry>(tocSize / 4);
        this.otherTocEntryMaps = new HashMap();
    }

    @Override
    protected void internalAddEntry(TocEntryObject entry) {
        if (entry instanceof ProductCmptTocEntry) {
            ProductCmptTocEntry prodEntry = (ProductCmptTocEntry)entry;
            this.pcIdTocEntryMap.put(prodEntry.getIpsObjectId(), prodEntry);
            this.pcNameTocEntryMap.put(prodEntry.getIpsObjectQualifiedName(), prodEntry);
            List<VersionIdTocEntry> versions = this.getVersionList(prodEntry.getKindId());
            versions.add(new VersionIdTocEntry(prodEntry.getVersionId(), prodEntry));
            return;
        }
        if (entry instanceof TableContentTocEntry) {
            this.tableImplClassTocEntryMap.put(entry.getImplementationClassName(), (TableContentTocEntry)entry);
            this.tableContentNameTocEntryMap.put(entry.getIpsObjectQualifiedName(), (TableContentTocEntry)entry);
            return;
        }
        if (entry instanceof TestCaseTocEntry) {
            this.testCaseNameTocEntryMap.put(entry.getIpsObjectQualifiedName(), (TestCaseTocEntry)entry);
            return;
        }
        if (entry instanceof FormulaTestTocEntry) {
            this.testCaseNameTocEntryMap.put(entry.getIpsObjectQualifiedName(), (FormulaTestTocEntry)entry);
            return;
        }
        if (entry instanceof ModelTypeTocEntry) {
            this.modelTypeNameTocEntryMap.put(entry.getIpsObjectQualifiedName(), (ModelTypeTocEntry)entry);
            return;
        }
        if (entry instanceof EnumContentTocEntry) {
            this.enumContentImplClassTocEntryMap.put(entry.getImplementationClassName(), (EnumContentTocEntry)entry);
            return;
        }
        if (entry instanceof EnumXmlAdapterTocEntry) {
            this.enumXmlAdapterTocEntryMap.put(entry.getIpsObjectId(), (EnumXmlAdapterTocEntry)entry);
            return;
        }
        if (entry instanceof CustomTocEntryObject) {
            this.putTypedTocEntryToMap((CustomTocEntryObject)entry);
            return;
        }
        throw new IllegalArgumentException("Unknown entry type " + entry);
    }

    private <T> void putTypedTocEntryToMap(CustomTocEntryObject<T> tocEntry) {
        Map<String, CustomTocEntryObject<?>> otherTocEntryMap = this.otherTocEntryMaps.get(tocEntry.getRuntimeObjectClass());
        if (otherTocEntryMap == null) {
            otherTocEntryMap = new HashMap();
            this.otherTocEntryMaps.put(tocEntry.getRuntimeObjectClass(), otherTocEntryMap);
        }
        otherTocEntryMap.put(tocEntry.getIpsObjectQualifiedName(), tocEntry);
    }

    @Override
    public List<ProductCmptTocEntry> getProductCmptTocEntries() {
        return new ArrayList<ProductCmptTocEntry>(this.pcIdTocEntryMap.values());
    }

    @Override
    public ProductCmptTocEntry getProductCmptTocEntry(String id) {
        return this.pcIdTocEntryMap.get(id);
    }

    @Override
    public ProductCmptTocEntry getProductCmptTocEntry(String kindId, String versionId) {
        if (kindId == null) {
            return null;
        }
        if (versionId == null) {
            throw new RuntimeException("VersionId must not be null!");
        }
        List<VersionIdTocEntry> versions = this.getVersionList(kindId);
        for (VersionIdTocEntry each : versions) {
            if (!versionId.equals(each.versionId)) continue;
            return each.tocEntry;
        }
        return null;
    }

    @Override
    public List<ProductCmptTocEntry> getProductCmptTocEntries(String kindId) {
        ArrayList<ProductCmptTocEntry> result = new ArrayList<ProductCmptTocEntry>();
        List<VersionIdTocEntry> versionList = this.getVersionList(kindId);
        for (VersionIdTocEntry each : versionList) {
            result.add(each.tocEntry);
        }
        return result;
    }

    private List<VersionIdTocEntry> getVersionList(String kindId) {
        List<VersionIdTocEntry> versions = this.kindIdTocEntryListMap.get(kindId);
        if (versions == null) {
            versions = new ArrayList<VersionIdTocEntry>(1);
            this.kindIdTocEntryListMap.put(kindId, versions);
        }
        return versions;
    }

    @Override
    public List<TableContentTocEntry> getTableTocEntries() {
        return new ArrayList<TableContentTocEntry>(this.tableContentNameTocEntryMap.values());
    }

    @Override
    public TableContentTocEntry getTableTocEntryByClassname(String implementationClass) {
        return this.tableImplClassTocEntryMap.get(implementationClass);
    }

    @Override
    public TableContentTocEntry getTableTocEntryByQualifiedTableName(String qualifiedTableName) {
        return this.tableContentNameTocEntryMap.get(qualifiedTableName);
    }

    @Override
    public List<TestCaseTocEntry> getTestCaseTocEntries() {
        return new ArrayList<TestCaseTocEntry>(this.testCaseNameTocEntryMap.values());
    }

    @Override
    public TestCaseTocEntry getTestCaseTocEntryByQName(String qName) {
        return this.testCaseNameTocEntryMap.get(qName);
    }

    @Override
    public Set<ModelTypeTocEntry> getModelTypeTocEntries() {
        return new HashSet<ModelTypeTocEntry>(this.modelTypeNameTocEntryMap.values());
    }

    @Override
    public List<EnumContentTocEntry> getEnumContentTocEntries() {
        return new ArrayList<EnumContentTocEntry>(this.enumContentImplClassTocEntryMap.values());
    }

    @Override
    public EnumContentTocEntry getEnumContentTocEntry(String className) {
        return this.enumContentImplClassTocEntryMap.get(className);
    }

    @Override
    public Set<EnumXmlAdapterTocEntry> getEnumXmlAdapterTocEntries() {
        return new HashSet<EnumXmlAdapterTocEntry>(this.enumXmlAdapterTocEntryMap.values());
    }

    public List<TocEntryObject> getEntries() {
        ArrayList<TocEntryObject> results = new ArrayList<TocEntryObject>();
        results.addAll(this.pcIdTocEntryMap.values());
        results.addAll(this.tableContentNameTocEntryMap.values());
        results.addAll(this.testCaseNameTocEntryMap.values());
        results.addAll(this.modelTypeNameTocEntryMap.values());
        results.addAll(this.enumContentImplClassTocEntryMap.values());
        results.addAll(this.enumXmlAdapterTocEntryMap.values());
        for (Map<String, CustomTocEntryObject<?>> otherTocEntryMap : this.otherTocEntryMaps.values()) {
            results.addAll(otherTocEntryMap.values());
        }
        return results;
    }

    @Override
    public <T> CustomTocEntryObject<T> getCustomTocEntry(Class<T> type, String ipsObjectQualifiedName) {
        Map<String, CustomTocEntryObject<?>> otherTocEntryMap = this.otherTocEntryMaps.get(type);
        if (otherTocEntryMap != null) {
            CustomTocEntryObject<?> typedTocEntryObject = otherTocEntryMap.get(ipsObjectQualifiedName);
            return typedTocEntryObject;
        }
        return null;
    }

    @Override
    public <T extends IRuntimeObject> List<CustomTocEntryObject<T>> getTypedTocEntries(Class<T> type) {
        Map<String, CustomTocEntryObject<?>> otherTocEntryMap = this.otherTocEntryMaps.get(type);
        ArrayList<CustomTocEntryObject<T>> list = new ArrayList<CustomTocEntryObject<T>>();
        if (otherTocEntryMap != null) {
            Collection<CustomTocEntryObject<?>> values = otherTocEntryMap.values();
            Iterator<CustomTocEntryObject<?>> iterator = values.iterator();
            while (iterator.hasNext()) {
                CustomTocEntryObject<?> typedTocEntryObject;
                CustomTocEntryObject<?> tocEntryObject = typedTocEntryObject = iterator.next();
                list.add(tocEntryObject);
            }
        }
        return list;
    }

    private class VersionIdTocEntry {
        private String versionId;
        private ProductCmptTocEntry tocEntry;

        public VersionIdTocEntry(String versionId, ProductCmptTocEntry entry) {
            this.versionId = versionId;
            this.tocEntry = entry;
        }
    }
}

