/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.IProductComponentLink;
import org.faktorips.runtime.model.annotation.IpsAssociationLinks;
import org.faktorips.runtime.model.type.Association;
import org.faktorips.runtime.model.type.PolicyCmptType;
import org.faktorips.runtime.model.type.ProductCmptType;
import org.faktorips.runtime.model.type.Type;

public class ProductAssociation
extends Association {
    private final boolean changingOverTime;
    private final Method getLinksMethod;

    public ProductAssociation(Type type, Method getterMethod, boolean changingOverTime, Method getLinksMethod) {
        super(type, getterMethod);
        this.changingOverTime = changingOverTime;
        this.getLinksMethod = getLinksMethod;
    }

    @Override
    public ProductAssociation createOverwritingAssociationFor(Type subType) {
        return new ProductAssociation(subType, this.getGetterMethod(), this.changingOverTime, this.getLinksMethod);
    }

    @Override
    public ProductCmptType getType() {
        return (ProductCmptType)super.getType();
    }

    @Override
    @Deprecated
    public ProductCmptType getModelType() {
        return this.getType();
    }

    @Override
    public ProductCmptType getTarget() {
        return (ProductCmptType)super.getTarget();
    }

    public List<IProductComponent> getTargetObjects(IProductComponent productComponentSource, Calendar effectiveDate) {
        ArrayList<IProductComponent> targets = new ArrayList<IProductComponent>();
        Object source = ProductAssociation.getRelevantProductObject(productComponentSource, effectiveDate, this.isChangingOverTime());
        Object returnValue = this.invokeMethod(this.getGetterMethod(), source, new Object[0]);
        if (returnValue instanceof Iterable) {
            for (Object target : (Iterable)returnValue) {
                targets.add((IProductComponent)target);
            }
        } else if (returnValue instanceof IProductComponent) {
            targets.add((IProductComponent)returnValue);
        }
        return targets;
    }

    @Override
    public PolicyCmptType getMatchingAssociationSourceType() {
        return (PolicyCmptType)super.getMatchingAssociationSourceType();
    }

    public boolean isChangingOverTime() {
        return this.changingOverTime;
    }

    public <T extends IProductComponent> Collection<IProductComponentLink<T>> getLinks(IProductComponent prodCmpt, Calendar effectiveDate) {
        if (this.isChangingOverTime()) {
            Object generation = ProductAssociation.getRelevantProductObject(prodCmpt, effectiveDate, true);
            return this.getLinksFromObject(generation);
        }
        return this.getLinksFromObject(prodCmpt);
    }

    private <T extends IProductComponent> Collection<IProductComponentLink<T>> getLinksFromObject(Object prodCmptOrGeneration) {
        if (this.getLinksMethod == null) {
            throw new IllegalArgumentException(String.format("The association %s on %s does not allow retrieving links%s.", this.getName(), prodCmptOrGeneration, this.isDerivedUnion() ? " because it is a derived union" : "; make sure a method annotated with @" + IpsAssociationLinks.class + " exists"));
        }
        if (this.isToOneAssociation()) {
            IProductComponentLink link = (IProductComponentLink)this.invokeMethod(this.getLinksMethod, prodCmptOrGeneration, new Object[0]);
            if (link == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(link);
        }
        return (Collection)this.invokeMethod(this.getLinksMethod, prodCmptOrGeneration, new Object[0]);
    }
}

