/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.internal.toc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.faktorips.runtime.IRuntimeObject;
import org.faktorips.runtime.internal.toc.AbstractTocEntryFactory;
import org.faktorips.runtime.internal.toc.CustomTocEntryObject;
import org.faktorips.runtime.internal.toc.EnumContentTocEntry;
import org.faktorips.runtime.internal.toc.EnumXmlAdapterTocEntry;
import org.faktorips.runtime.internal.toc.IReadonlyTableOfContents;
import org.faktorips.runtime.internal.toc.ITocEntryFactory;
import org.faktorips.runtime.internal.toc.ModelTypeTocEntry;
import org.faktorips.runtime.internal.toc.ProductCmptTocEntry;
import org.faktorips.runtime.internal.toc.TableContentTocEntry;
import org.faktorips.runtime.internal.toc.TestCaseTocEntry;
import org.faktorips.runtime.internal.toc.TocEntryObject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractReadonlyTableOfContents
implements IReadonlyTableOfContents {
    public static final String TOC_XML_ELEMENT = "FaktorIps-TableOfContents";
    public static final String PRODUCT_DATA_VERSION_XML_ELEMENT = "productDataVersion";
    private String productDataVersion;
    private Map<String, ITocEntryFactory<?>> tocEntryFactoriesByXmlTag;
    private final ClassLoader classLoader;

    public AbstractReadonlyTableOfContents(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, ITocEntryFactory<?>> getTocEntryFactoriesByXmlTag() {
        if (this.tocEntryFactoriesByXmlTag != null) return this.tocEntryFactoriesByXmlTag;
        Class<TocEntryObject> clazz = TocEntryObject.class;
        synchronized (TocEntryObject.class) {
            if (this.tocEntryFactoriesByXmlTag != null) return this.tocEntryFactoriesByXmlTag;
            this.tocEntryFactoriesByXmlTag = new HashMap();
            for (ITocEntryFactory<?> tocEntryFactory : AbstractTocEntryFactory.getBaseTocEntryFactories()) {
                this.tocEntryFactoriesByXmlTag.put(tocEntryFactory.getXmlTag(), tocEntryFactory);
            }
            this.loadExtendedTocEntryFactories();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.tocEntryFactoriesByXmlTag;
        }
    }

    private void loadExtendedTocEntryFactories() {
        ServiceLoader<ITocEntryFactory> serviceLoader = ServiceLoader.load(ITocEntryFactory.class, this.classLoader);
        for (ITocEntryFactory tocEntryFactory : serviceLoader) {
            this.tocEntryFactoriesByXmlTag.put(tocEntryFactory.getXmlTag(), tocEntryFactory);
        }
    }

    public void initFromXml(Element tocElement) {
        this.productDataVersion = tocElement.getAttribute(PRODUCT_DATA_VERSION_XML_ELEMENT);
        if (this.productDataVersion == null) {
            this.productDataVersion = "0";
        }
        NodeList nl = tocElement.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i) instanceof Element) {
                Element entryElement = (Element)nl.item(i);
                this.internalAddEntry((TocEntryObject)this.getTocEntryFactoriesByXmlTag().get(entryElement.getNodeName()).createFromXml(entryElement));
            }
            ++i;
        }
    }

    protected abstract void internalAddEntry(TocEntryObject var1);

    @Override
    public abstract ProductCmptTocEntry getProductCmptTocEntry(String var1);

    @Override
    public abstract ProductCmptTocEntry getProductCmptTocEntry(String var1, String var2);

    @Override
    public abstract List<ProductCmptTocEntry> getProductCmptTocEntries();

    @Override
    public abstract List<ProductCmptTocEntry> getProductCmptTocEntries(String var1);

    @Override
    public abstract List<TableContentTocEntry> getTableTocEntries();

    @Override
    public abstract List<TestCaseTocEntry> getTestCaseTocEntries();

    @Override
    public abstract TestCaseTocEntry getTestCaseTocEntryByQName(String var1);

    @Override
    public abstract TableContentTocEntry getTableTocEntryByClassname(String var1);

    @Override
    public abstract TableContentTocEntry getTableTocEntryByQualifiedTableName(String var1);

    @Override
    public abstract Set<ModelTypeTocEntry> getModelTypeTocEntries();

    @Override
    public abstract EnumContentTocEntry getEnumContentTocEntry(String var1);

    @Override
    public abstract Set<EnumXmlAdapterTocEntry> getEnumXmlAdapterTocEntries();

    @Override
    public String getProductDataVersion() {
        return this.productDataVersion;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("TOC");
        buf.append(System.getProperty("line.separator"));
        List<ProductCmptTocEntry> entries = this.getProductCmptTocEntries();
        for (ProductCmptTocEntry entry : entries) {
            buf.append(entry.toString());
            buf.append(System.getProperty("line.separator"));
        }
        List<TableContentTocEntry> tableEntries = this.getTableTocEntries();
        for (TableContentTocEntry entry : tableEntries) {
            buf.append(entry.toString());
            buf.append(System.getProperty("line.separator"));
        }
        List<TestCaseTocEntry> testEntries = this.getTestCaseTocEntries();
        for (TestCaseTocEntry entry : testEntries) {
            buf.append(entry.toString());
            buf.append(System.getProperty("line.separator"));
        }
        return buf.toString();
    }

    public abstract <T extends IRuntimeObject> List<CustomTocEntryObject<T>> getTypedTocEntries(Class<T> var1);
}

