/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.runtime.model.type;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.faktorips.runtime.IModelObject;
import org.faktorips.runtime.IProductComponent;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.model.IpsModel;
import org.faktorips.runtime.model.annotation.AnnotatedDeclaration;
import org.faktorips.runtime.model.annotation.IpsChangingOverTime;
import org.faktorips.runtime.model.annotation.IpsConfigures;
import org.faktorips.runtime.model.type.PolicyCmptType;
import org.faktorips.runtime.model.type.ProductAssociation;
import org.faktorips.runtime.model.type.ProductAttribute;
import org.faktorips.runtime.model.type.TableUsage;
import org.faktorips.runtime.model.type.Type;
import org.faktorips.runtime.model.type.TypeHierarchyVisitor;
import org.faktorips.runtime.model.type.read.ProductAssociationCollector;
import org.faktorips.runtime.model.type.read.ProductAttributeCollector;
import org.faktorips.runtime.model.type.read.TableUsageCollector;
import org.faktorips.runtime.model.type.read.TypePartsReader;

public class ProductCmptType
extends Type {
    public static final String KIND_NAME = "ProductCmptType2";
    private final AnnotatedDeclaration generationDeclaration;
    private final LinkedHashMap<String, ProductAttribute> attributes;
    private final LinkedHashMap<String, ProductAssociation> associations;
    private final LinkedHashMap<String, TableUsage> tableUsages;

    public ProductCmptType(String name, AnnotatedDeclaration annotatedDeclaration) {
        super(name, annotatedDeclaration);
        this.generationDeclaration = this.isChangingOverTime() ? AnnotatedDeclaration.from(annotatedDeclaration.get(IpsChangingOverTime.class).value()) : null;
        ProductAttributeCollector attributeCollector = new ProductAttributeCollector();
        ProductAssociationCollector associationCollector = new ProductAssociationCollector();
        TableUsageCollector tableUsageCollector = new TableUsageCollector();
        this.initParts(attributeCollector, associationCollector, tableUsageCollector);
        this.attributes = attributeCollector.createParts(this);
        this.associations = associationCollector.createParts(this);
        this.tableUsages = tableUsageCollector.createParts(this);
    }

    private void initParts(ProductAttributeCollector attributeCollector, ProductAssociationCollector associationCollector, TableUsageCollector tableUsageCollector) {
        TypePartsReader typePartsReader = new TypePartsReader(attributeCollector, associationCollector, tableUsageCollector);
        typePartsReader.init(this.getAnnotatedDeclaration());
        typePartsReader.read(this.getAnnotatedDeclaration());
        if (this.isChangingOverTime()) {
            typePartsReader.read(this.generationDeclaration);
        }
    }

    @Override
    protected String getKindName() {
        return KIND_NAME;
    }

    @Override
    protected List<Method> getDeclaredMethods() {
        List<Method> result = super.getDeclaredMethods();
        if (this.isChangingOverTime()) {
            result.addAll(this.generationDeclaration.getDeclaredMethods());
        }
        return result;
    }

    public boolean isChangingOverTime() {
        return this.getAnnotatedDeclaration().is(IpsChangingOverTime.class);
    }

    public boolean isConfigurationForPolicyCmptType() {
        return this.getAnnotatedDeclaration().is(IpsConfigures.class);
    }

    public PolicyCmptType getPolicyCmptType() {
        return IpsModel.getPolicyCmptType(this.getAnnotatedDeclaration().get(IpsConfigures.class).value().asSubclass(IModelObject.class));
    }

    public TableUsage getTableUsage(String name) {
        TableUsageFinder finder = new TableUsageFinder(name);
        finder.visitHierarchy(this);
        if (finder.tableUsage == null) {
            throw new IllegalArgumentException("The type " + this + " (or one of it's super types) hasn't got a table usage \"" + name + "\"");
        }
        return finder.tableUsage;
    }

    public List<TableUsage> getDeclaredTableUsages() {
        return new ArrayList<TableUsage>(this.tableUsages.values());
    }

    public TableUsage getDeclaredTableUsage(String name) {
        TableUsage tableUsage = this.tableUsages.get(name);
        if (tableUsage == null) {
            throw new IllegalArgumentException("The type " + this + " hasn't got a declared table usage " + name);
        }
        return tableUsage;
    }

    protected boolean hasDeclaredTableUsage(String name) {
        return this.tableUsages.containsKey(name);
    }

    public List<TableUsage> getTableUsages() {
        TableUsagesCollector tuCollector = new TableUsagesCollector();
        tuCollector.visitHierarchy(this);
        return tuCollector.result;
    }

    public Class<?> getGenerationJavaClass() {
        if (this.generationDeclaration != null) {
            return this.generationDeclaration.getImplementationClass();
        }
        return null;
    }

    public Class<?> getGenerationJavaInterface() {
        if (this.generationDeclaration != null) {
            return this.generationDeclaration.getPublishedInterface();
        }
        return null;
    }

    public Class<?> getGenerationDeclarationClass() {
        return this.getGenerationJavaInterface() == null ? this.getGenerationJavaClass() : this.getGenerationJavaInterface();
    }

    @Override
    public ProductCmptType getSuperType() {
        Class<?> superclass = this.getJavaClass().getSuperclass();
        return IpsModel.isProductCmptType(superclass) ? IpsModel.getProductCmptType(superclass.asSubclass(IProductComponent.class)) : null;
    }

    @Override
    public ProductAttribute getDeclaredAttribute(int index) {
        return this.getDeclaredAttributes().get(index);
    }

    @Override
    public ProductAttribute getDeclaredAttribute(String name) {
        ProductAttribute attr = this.attributes.get(IpsStringUtils.toLowerFirstChar(name));
        if (attr == null) {
            throw new IllegalArgumentException("The type " + this + " hasn't got a declared attribute " + name);
        }
        return attr;
    }

    public List<ProductAttribute> getDeclaredAttributes() {
        return new ArrayList<ProductAttribute>(this.attributes.values());
    }

    @Override
    public ProductAttribute getAttribute(String name) {
        return (ProductAttribute)super.getAttribute(name);
    }

    public List<ProductAttribute> getAttributes() {
        Type.AttributeCollector attrCollector = new Type.AttributeCollector();
        attrCollector.visitHierarchy(this);
        return attrCollector.getResult();
    }

    @Override
    protected boolean hasDeclaredAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    @Override
    public ProductAssociation getDeclaredAssociation(int index) {
        return (ProductAssociation)super.getDeclaredAssociation(index);
    }

    @Override
    public ProductAssociation getDeclaredAssociation(String name) {
        ProductAssociation productAssociation = this.associations.get(IpsStringUtils.toLowerFirstChar(name));
        if (productAssociation == null) {
            throw new IllegalArgumentException("The type " + this + " hasn't got a declared association " + name);
        }
        return productAssociation;
    }

    public List<ProductAssociation> getDeclaredAssociations() {
        return new ArrayList<ProductAssociation>(new LinkedHashSet<ProductAssociation>(this.associations.values()));
    }

    @Override
    protected boolean hasDeclaredAssociation(String name) {
        return this.associations.containsKey(name);
    }

    @Override
    public ProductAssociation getAssociation(String name) {
        return (ProductAssociation)super.getAssociation(name);
    }

    public List<ProductAssociation> getAssociations() {
        Type.AssociationsCollector asscCollector = new Type.AssociationsCollector();
        asscCollector.visitHierarchy(this);
        return asscCollector.getResult();
    }

    static class TableUsageFinder
    extends TypeHierarchyVisitor {
        private String tableUsageName;
        private TableUsage tableUsage = null;

        public TableUsageFinder(String name) {
            this.tableUsageName = name;
        }

        @Override
        public boolean visitType(Type type) {
            boolean hasDeclaredTableUsage = ((ProductCmptType)type).hasDeclaredTableUsage(this.tableUsageName);
            if (hasDeclaredTableUsage) {
                this.tableUsage = ((ProductCmptType)type).getDeclaredTableUsage(this.tableUsageName);
            }
            return !hasDeclaredTableUsage;
        }
    }

    static class TableUsagesCollector
    extends TypeHierarchyVisitor {
        private List<TableUsage> result = new ArrayList<TableUsage>();

        TableUsagesCollector() {
        }

        @Override
        public boolean visitType(Type type) {
            this.result.addAll(((ProductCmptType)type).getDeclaredTableUsages());
            return true;
        }
    }
}

