/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.testsupport.matchers;

import java.util.Optional;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.ObjectProperty;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class MessageInvalidObjectMatcher
extends TypeSafeMatcher<Message> {
    private Object invalidObject;
    private Optional<String> propertyName;

    public MessageInvalidObjectMatcher(Object invalidObject) {
        this.invalidObject = invalidObject;
        this.propertyName = Optional.empty();
    }

    public MessageInvalidObjectMatcher(Object invalidObject, String propertyName) {
        this.invalidObject = invalidObject;
        this.propertyName = Optional.ofNullable(propertyName);
    }

    public void describeTo(Description description) {
        description.appendText("a message containing the invalid object: " + this.invalidObject);
        if (this.propertyName.isPresent()) {
            description.appendText(" for the property: " + this.propertyName.get());
        }
    }

    public boolean matchesSafely(Message message) {
        for (ObjectProperty objectProperty : message.getInvalidObjectProperties()) {
            if (this.propertyName.isPresent() && !this.propertyName.get().equals(objectProperty.getProperty()) || !objectProperty.getObject().equals(this.invalidObject)) continue;
            return true;
        }
        return false;
    }
}

