/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.testsupport.matchers;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.Objects;
import org.faktorips.runtime.Message;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class MessageCodeMatcher
extends TypeSafeMatcher<Message> {
    @CheckForNull
    private final String messageCode;
    private boolean expectMessage;

    public MessageCodeMatcher(@CheckForNull String messageCode) {
        this.messageCode = messageCode;
        this.expectMessage = true;
    }

    public MessageCodeMatcher(@CheckForNull String messageCode, boolean expectMessage) {
        this.messageCode = messageCode;
        this.expectMessage = expectMessage;
    }

    public void describeTo(Description description) {
        if (this.expectMessage) {
            description.appendText("a message with message code " + this.messageCode);
        } else {
            description.appendText("a message without message code: " + this.messageCode);
        }
    }

    protected boolean matchesSafely(Message m) {
        return Objects.equals(this.messageCode, m.getCode()) == this.expectMessage;
    }
}

