/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.testsupport;

import java.util.function.Function;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.Severity;
import org.faktorips.testsupport.matchers.EmptyMessageListMatcher;
import org.faktorips.testsupport.matchers.MessageCodeMatcher;
import org.faktorips.testsupport.matchers.MessageInvalidObjectMatcher;
import org.faktorips.testsupport.matchers.MessageListCodeMatcher;
import org.faktorips.testsupport.matchers.MessageListMessageMatcher;
import org.faktorips.testsupport.matchers.MessageListObjectPropertyMatcher;
import org.faktorips.testsupport.matchers.MessageListSizeMatcher;
import org.faktorips.testsupport.matchers.MessageSeverityMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.core.CombinableMatcher;

public class IpsMatchers {
    private IpsMatchers() {
    }

    public static EmptyMessageListMatcher isEmpty() {
        return new EmptyMessageListMatcher();
    }

    public static Matcher<MessageList> containsMessages() {
        return CoreMatchers.not((Matcher)new EmptyMessageListMatcher());
    }

    public static MessageListSizeMatcher hasSize(int size) {
        return new MessageListSizeMatcher((Matcher<Integer>)CoreMatchers.equalTo((Object)size));
    }

    public static MessageListSizeMatcher hasSize(Matcher<Integer> intMatcher) {
        return new MessageListSizeMatcher(intMatcher);
    }

    public static MessageListObjectPropertyMatcher hasMessageFor(Object object) {
        return new MessageListObjectPropertyMatcher(new ObjectProperty(object));
    }

    public static MessageListObjectPropertyMatcher hasMessageFor(Object object, String property) {
        return new MessageListObjectPropertyMatcher(new ObjectProperty(object, property));
    }

    public static MessageListObjectPropertyMatcher hasMessagesFor(int count, Object object, String property) {
        return new MessageListObjectPropertyMatcher(new ObjectProperty(object, property), count);
    }

    public static Matcher<MessageList> hasMessageCode(String code) {
        return new MessageListCodeMatcher(code);
    }

    public static Matcher<MessageList> lacksMessageCode(String code) {
        return new MessageListCodeMatcher(code, false);
    }

    public static MessageListMessageMatcher hasInfoMessage(String code) {
        return new MessageListMessageMatcher(IpsMatchers.codeAndSeverity(code, Severity.INFO));
    }

    public static MessageListMessageMatcher hasWarningMessage(String code) {
        return new MessageListMessageMatcher(IpsMatchers.codeAndSeverity(code, Severity.WARNING));
    }

    public static MessageListMessageMatcher hasErrorMessage(String code) {
        return new MessageListMessageMatcher(IpsMatchers.codeAndSeverity(code, Severity.ERROR));
    }

    public static MessageListMessageMatcher hasMessageWithSeverity(Severity severity) {
        return new MessageListMessageMatcher(new Matcher[]{new MessageSeverityMatcher(severity)});
    }

    public static MessageListMessageMatcher containsErrorMessage() {
        return new MessageListMessageMatcher(new Matcher[]{new MessageSeverityMatcher(Severity.ERROR)});
    }

    public static Matcher<MessageList> containsNoErrorMessage() {
        return CoreMatchers.not((Matcher)new MessageListMessageMatcher(new Matcher[]{new MessageSeverityMatcher(Severity.ERROR)}));
    }

    public static MessageListMessageMatcher hasMessageThat(Matcher<Message> messageMatcher) {
        return new MessageListMessageMatcher(messageMatcher);
    }

    @SafeVarargs
    public static Matcher<MessageList> hasMessages(Matcher<Message> ... messageMatchers) {
        return new MessageListMessageMatcher(messageMatchers);
    }

    public static Matcher<Message> containsText(String text) {
        return IpsMatchers.hasFeature(Message::getText, CoreMatchers.containsString((String)text), "a message where the text is", "text");
    }

    public static Matcher<Message> hasSeverity(Severity severity) {
        return new MessageSeverityMatcher(severity);
    }

    private static Matcher<Message> codeAndSeverity(String code, Severity severity) {
        return CombinableMatcher.both((Matcher)new MessageCodeMatcher(code)).and((Matcher)new MessageSeverityMatcher(severity));
    }

    public static Matcher<Message> hasInvalidObject(Object invalidObject) {
        return new MessageInvalidObjectMatcher(invalidObject);
    }

    public static Matcher<Message> hasInvalidObject(Object invalidObject, String propertyName) {
        return new MessageInvalidObjectMatcher(invalidObject, propertyName);
    }

    public static <T, U> FeatureMatcher<T, U> hasFeature(final Function<T, U> featureExtractor, Matcher<U> featureMatcher, String featureDescription, String featureName) {
        return new FeatureMatcher<T, U>(featureMatcher, featureDescription, featureName){

            protected U featureValueOf(T actual) {
                return featureExtractor.apply(actual);
            }
        };
    }
}

