/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.testsupport;

import java.time.Duration;
import java.util.function.BooleanSupplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class Wait {
    private Duration duration;

    private Wait(Duration duration) {
        this.duration = duration;
    }

    public static Wait atMost(Duration duration) {
        return new Wait(duration);
    }

    public void until(BooleanSupplier check, String failureMessage) {
        long max = this.duration.getSeconds() * 1000L + (long)this.duration.getNano() / 1000000L;
        for (long l = 1L; l < max && !check.getAsBoolean(); l *= 5L) {
            try {
                Thread.sleep(l);
                continue;
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        MatcherAssert.assertThat((String)failureMessage, (Object)check.getAsBoolean(), (Matcher)CoreMatchers.is((Object)true));
    }
}

