/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.testsupport.matchers;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import org.faktorips.runtime.Message;
import org.faktorips.testsupport.matchers.MessageMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class MessageCodeMatcher
extends MessageMatcher {
    private final Matcher<String> messageCodeMatcher;
    private boolean expectMessage;

    public MessageCodeMatcher(@CheckForNull String messageCode) {
        this(messageCode, true);
    }

    public MessageCodeMatcher(@CheckForNull String messageCode, boolean expectMessage) {
        this((Matcher<String>)CoreMatchers.equalTo((Object)messageCode), expectMessage);
    }

    public MessageCodeMatcher(Matcher<String> messageCodeMatcher) {
        this(messageCodeMatcher, true);
    }

    public MessageCodeMatcher(Matcher<String> messageCodeMatcher, boolean expectMessage) {
        this.messageCodeMatcher = messageCodeMatcher;
        this.expectMessage = expectMessage;
    }

    @Override
    protected void describeMessageProperty(Description description) {
        if (this.expectMessage) {
            description.appendText("has a message code ");
        } else {
            description.appendText("does not have a message code ");
        }
        this.messageCodeMatcher.describeTo(description);
    }

    @Override
    protected void describeMismatchedProperty(Message message, Description mismatchDescription) {
        mismatchDescription.appendText(" has the message code ");
        mismatchDescription.appendText(message.getCode());
    }

    protected boolean matchesSafely(Message message) {
        return this.messageCodeMatcher.matches((Object)message.getCode()) == this.expectMessage;
    }
}

