/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.testsupport.matchers;

import java.util.Optional;
import java.util.stream.Collectors;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.testsupport.matchers.MessageMatcher;
import org.hamcrest.Description;

public class MessageInvalidObjectMatcher
extends MessageMatcher {
    private Object invalidObject;
    private Optional<String> propertyName;

    public MessageInvalidObjectMatcher(Object invalidObject) {
        this.invalidObject = invalidObject;
        this.propertyName = Optional.empty();
    }

    public MessageInvalidObjectMatcher(Object invalidObject, String propertyName) {
        this.invalidObject = invalidObject;
        this.propertyName = Optional.ofNullable(propertyName);
    }

    @Override
    protected void describeMessageProperty(Description description) {
        description.appendText("contains the invalid object: " + this.invalidObject);
        if (this.propertyName.isPresent()) {
            description.appendText(" for the property: " + this.propertyName.get());
        }
    }

    @Override
    protected void describeMismatchedProperty(Message message, Description mismatchDescription) {
        mismatchDescription.appendText("had ");
        switch (message.getNumOfInvalidObjectProperties()) {
            case 0: {
                mismatchDescription.appendText("no invalid object properties");
                break;
            }
            case 1: {
                mismatchDescription.appendText("only the invalid object property ");
                mismatchDescription.appendValue(message.getInvalidObjectProperties().get(0));
                break;
            }
            default: {
                mismatchDescription.appendText("the invalid object properties ");
                mismatchDescription.appendValue((Object)message.getInvalidObjectProperties().stream().map(ObjectProperty::toString).collect(Collectors.joining(", ")));
            }
        }
    }

    public boolean matchesSafely(Message message) {
        for (ObjectProperty objectProperty : message.getInvalidObjectProperties()) {
            if (this.propertyName.isPresent() && !this.propertyName.get().equals(objectProperty.getProperty()) || !objectProperty.getObject().equals(this.invalidObject)) continue;
            return true;
        }
        return false;
    }
}

