/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.testsupport.matchers;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.function.Function;
import org.faktorips.runtime.Message;
import org.faktorips.testsupport.matchers.MessageMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class MessagePropertyMatcher<P>
extends MessageMatcher {
    private final Function<Message, P> propertyExtractor;
    private final Matcher<P> propertyMatcher;
    private final String propertyDescription;
    @CheckForNull
    private StringDescription lastMismatchDescription = null;

    public MessagePropertyMatcher(Function<Message, P> propertyExtractor, Matcher<P> propertyMatcher, String propertyDescription) {
        this.propertyExtractor = propertyExtractor;
        this.propertyMatcher = propertyMatcher;
        this.propertyDescription = propertyDescription;
    }

    protected boolean matchesSafely(Message item) {
        P propertyValue = this.propertyExtractor.apply(item);
        boolean matches = this.propertyMatcher.matches(propertyValue);
        if (!matches) {
            this.lastMismatchDescription = new StringDescription();
            this.lastMismatchDescription.appendText(this.propertyDescription);
            this.lastMismatchDescription.appendText(" that ");
            this.propertyMatcher.describeMismatch(propertyValue, (Description)this.lastMismatchDescription);
        } else {
            this.lastMismatchDescription = null;
        }
        return matches;
    }

    @Override
    protected void describeMismatchedProperty(Message message, Description mismatchDescription) {
        if (this.lastMismatchDescription != null) {
            mismatchDescription.appendText(this.lastMismatchDescription.toString());
        }
    }

    @Override
    protected void describeMessageProperty(Description description) {
        description.appendText(this.propertyDescription);
        description.appendText(" that is ");
        this.propertyMatcher.describeTo(description);
    }
}

