/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.testsupport;

import java.util.Arrays;
import java.util.Objects;
import org.faktorips.valueset.Range;
import org.faktorips.valueset.ValueSet;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ValueSetMatchers {
    private ValueSetMatchers() {
    }

    public static Matcher<ValueSet<?>> empty() {
        return new TypeSafeMatcher<ValueSet<?>>(){

            public void describeTo(Description description) {
                description.appendText("an empty value set");
            }

            protected boolean matchesSafely(ValueSet<?> valueSet) {
                return valueSet.isEmpty();
            }
        };
    }

    public static Matcher<ValueSet<?>> containsNull() {
        return new TypeSafeMatcher<ValueSet<?>>(){

            public void describeTo(Description description) {
                description.appendText("a value set containing null");
            }

            protected boolean matchesSafely(ValueSet<?> valueSet) {
                return valueSet.containsNull();
            }
        };
    }

    public static <T extends Comparable<T>> Matcher<ValueSet<T>> isRange(final T lower, final T upper) {
        return new TypeSafeMatcher<ValueSet<T>>(){

            public void describeTo(Description description) {
                description.appendText("a range value set from " + String.valueOf(lower) + " to " + String.valueOf(upper));
            }

            protected boolean matchesSafely(ValueSet<T> valueSet) {
                return valueSet.isRange() && Objects.equals(((Range)valueSet).getLowerBound(), lower) && Objects.equals(((Range)valueSet).getUpperBound(), upper);
            }
        };
    }

    public static <T> Matcher<ValueSet<T>> contains(final T ... values) {
        return new TypeSafeMatcher<ValueSet<T>>(){

            public void describeTo(Description description) {
                description.appendText("a value set containing " + Arrays.toString(values));
            }

            protected boolean matchesSafely(ValueSet<T> valueSet) {
                return Arrays.stream(values).allMatch(v -> valueSet.contains(v));
            }
        };
    }
}

