/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.testsupport.matchers;

import java.util.LinkedHashSet;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.testsupport.matchers.MessageMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeMatcher;

public class MessageListMessageMatcher
extends TypeSafeMatcher<MessageList> {
    private final Matcher<Message>[] messageMatchers;
    private Description mismatchDescription;

    @SafeVarargs
    public MessageListMessageMatcher(Matcher<Message> ... messageMatchers) {
        this.messageMatchers = messageMatchers;
        this.mismatchDescription = new StringDescription();
    }

    public void describeTo(Description description) {
        boolean first = true;
        description.appendText("a " + MessageList.class.getSimpleName() + " containing a message that ");
        for (Matcher<Message> matcher : this.messageMatchers) {
            if (!first) {
                description.appendText("\n AND ");
            } else {
                first = false;
            }
            if (matcher instanceof MessageMatcher) {
                MessageMatcher messageMatcher = (MessageMatcher)matcher;
                messageMatcher.describeMessageProperty(description);
                continue;
            }
            matcher.describeTo(description);
        }
    }

    protected boolean matchesSafely(MessageList messageList) {
        boolean allMatch = true;
        LinkedHashSet messages = new LinkedHashSet(messageList.getMessages());
        this.mismatchDescription = new StringDescription();
        for (Matcher<Message> messageMatcher : this.messageMatchers) {
            Message message2;
            block7: {
                for (Message message2 : messages) {
                    if (!messageMatcher.matches((Object)message2)) continue;
                    break block7;
                }
                allMatch = false;
                break;
            }
            messages.remove(message2);
        }
        if (!allMatch) {
            this.mismatchDescription.appendText("the " + MessageList.class.getSimpleName());
            switch (messageList.size()) {
                case 0: {
                    this.mismatchDescription.appendText(" contained no message");
                    break;
                }
                case 1: {
                    this.mismatchDescription.appendText(" only contained the message ");
                    this.mismatchDescription.appendValue((Object)messageList);
                    break;
                }
                default: {
                    this.mismatchDescription.appendText(" only contained the messages ");
                    this.mismatchDescription.appendValue((Object)messageList);
                }
            }
        }
        return allMatch;
    }

    protected void describeMismatchSafely(MessageList item, Description mismatchDescription) {
        mismatchDescription.appendText(this.mismatchDescription.toString());
    }
}

