/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.testsupport.matchers;

import java.util.stream.Collectors;
import org.faktorips.runtime.IMarker;
import org.faktorips.runtime.Message;
import org.faktorips.testsupport.matchers.MessageMatcher;
import org.hamcrest.Description;

public class MessageMarkerMatcher
extends MessageMatcher {
    private final IMarker marker;

    public MessageMarkerMatcher(IMarker marker) {
        this.marker = marker;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("a message with marker " + String.valueOf(this.marker));
    }

    protected boolean matchesSafely(Message m) {
        return m.hasMarker(this.marker);
    }

    @Override
    protected void describeMessageProperty(Description description) {
        description.appendText("has the marker " + String.valueOf(this.marker));
    }

    @Override
    protected void describeMismatchedProperty(Message message, Description mismatchDescription) {
        mismatchDescription.appendText("had ");
        switch (message.getMarkers().size()) {
            case 0: {
                mismatchDescription.appendText("no markers");
                break;
            }
            case 1: {
                mismatchDescription.appendText("only the marker ");
                mismatchDescription.appendValue(message.getMarkers().iterator().next());
                break;
            }
            default: {
                mismatchDescription.appendText("the markers ");
                mismatchDescription.appendValue((Object)message.getMarkers().stream().map(IMarker::toString).collect(Collectors.joining(", ")));
            }
        }
    }
}

