/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model;

import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.util.ArgumentCheck;

public class ContentChangeEvent {
    public static final int TYPE_WHOLE_CONTENT_CHANGED = 1;
    public static final int TYPE_PROPERTY_CHANGED = 2;
    public static final int TYPE_PART_ADDED = 4;
    public static final int TYPE_PART_REMOVED = 8;
    public static final int TYPE_PARTS_CHANGED_POSITIONS = 16;
    private final IIpsSrcFile ipsSrcFile;
    private final IIpsObjectPartContainer part;
    private final List<IIpsObjectPart> movedParts;
    private final int type;
    private final Set<PropertyChangeEvent> propertyChangeEvents;

    private ContentChangeEvent(IIpsSrcFile ipsSrcFile, PropertyChangeEvent ... propertyChangeEvents) {
        this.ipsSrcFile = ipsSrcFile;
        this.type = 1;
        this.propertyChangeEvents = new LinkedHashSet<PropertyChangeEvent>(Arrays.asList(propertyChangeEvents));
        this.part = null;
        this.movedParts = null;
    }

    private ContentChangeEvent(IIpsSrcFile ipsSrcFile, Set<PropertyChangeEvent> propertyChangeEvents) {
        this.ipsSrcFile = ipsSrcFile;
        this.type = 1;
        this.propertyChangeEvents = propertyChangeEvents;
        this.part = null;
        this.movedParts = null;
    }

    private ContentChangeEvent(IIpsObjectPartContainer part, int eventType) {
        ArgumentCheck.notNull((Object)part);
        this.part = part;
        this.ipsSrcFile = part.getIpsObject().getIpsSrcFile();
        this.type = eventType;
        this.propertyChangeEvents = Collections.emptySet();
        this.movedParts = null;
    }

    private ContentChangeEvent(IIpsSrcFile file, IIpsObjectPart[] parts) {
        this.ipsSrcFile = file;
        this.movedParts = Collections.unmodifiableList(Arrays.asList(parts));
        this.type = 16;
        this.propertyChangeEvents = Collections.emptySet();
        this.part = null;
    }

    private ContentChangeEvent(List<? extends IIpsObjectPart> parts) {
        this.movedParts = Collections.unmodifiableList(parts);
        this.type = 16;
        this.ipsSrcFile = parts.get(0).getIpsSrcFile();
        this.part = null;
        this.propertyChangeEvents = Collections.emptySet();
    }

    private ContentChangeEvent(IIpsObjectPartContainer part, PropertyChangeEvent ... propertyChangeEvents) {
        ArgumentCheck.notNull((Object)part);
        this.part = part;
        this.ipsSrcFile = part.getIpsSrcFile();
        this.type = 2;
        this.propertyChangeEvents = new LinkedHashSet<PropertyChangeEvent>(Arrays.asList(propertyChangeEvents));
        this.movedParts = null;
    }

    private ContentChangeEvent(IIpsSrcFile srcFile, IIpsObjectPartContainer part, int type, Set<PropertyChangeEvent> propertyChangeEvents) {
        this.part = part;
        this.ipsSrcFile = srcFile;
        this.type = type;
        this.propertyChangeEvents = propertyChangeEvents;
        this.movedParts = null;
    }

    public static final ContentChangeEvent newPartAddedEvent(IIpsObjectPart part) {
        return new ContentChangeEvent((IIpsObjectPartContainer)part, 4);
    }

    public static final ContentChangeEvent newPartRemovedEvent(IIpsObjectPartContainer part) {
        return new ContentChangeEvent(part, 8);
    }

    public static final ContentChangeEvent newPartChangedEvent(IIpsObjectPartContainer part) {
        return new ContentChangeEvent(part, 2);
    }

    public static final ContentChangeEvent newPartChangedEvent(IIpsObjectPartContainer part, PropertyChangeEvent ... propertyChangeEvents) {
        ArgumentCheck.isTrue((propertyChangeEvents.length > 0 ? 1 : 0) != 0);
        return new ContentChangeEvent(part, propertyChangeEvents);
    }

    public static final ContentChangeEvent newPartsChangedPositionsChangedEvent(IIpsSrcFile file, IIpsObjectPart[] parts) {
        return new ContentChangeEvent(file, parts);
    }

    public static final ContentChangeEvent newPartsChangedPositionsChangedEvent(List<? extends IIpsObjectPart> parts) {
        return new ContentChangeEvent(parts);
    }

    public static final ContentChangeEvent newWholeContentChangedEvent(IIpsSrcFile file, PropertyChangeEvent ... propertyChangeEvents) {
        return new ContentChangeEvent(file, propertyChangeEvents);
    }

    public static final ContentChangeEvent mergeChangeEvents(ContentChangeEvent ce1, ContentChangeEvent ce2) {
        if (!Objects.equals(ce1.getIpsSrcFile(), ce2.getIpsSrcFile())) {
            throw new IllegalArgumentException("Can only merge change events from same source file. Was " + ce1.getIpsSrcFile() + " and " + ce2.getIpsSrcFile());
        }
        LinkedHashSet<PropertyChangeEvent> propertyChangeEvents = new LinkedHashSet<PropertyChangeEvent>(ce1.getPropertyChangeEvents());
        propertyChangeEvents.addAll(ce2.getPropertyChangeEvents());
        if (ce1.getEventType() == ce2.getEventType() && Objects.equals(ce1.getPart(), ce2.getPart())) {
            return new ContentChangeEvent(ce1.getIpsSrcFile(), ce1.getPart(), ce1.getEventType(), propertyChangeEvents);
        }
        return new ContentChangeEvent(ce1.getIpsSrcFile(), propertyChangeEvents);
    }

    public IIpsSrcFile getIpsSrcFile() {
        return this.ipsSrcFile;
    }

    public int getEventType() {
        return this.type;
    }

    public IIpsObjectPartContainer getPart() {
        return this.part;
    }

    public IIpsObjectPart[] getMovedParts() {
        if (this.movedParts == null) {
            return new IIpsObjectPart[0];
        }
        return this.movedParts.toArray(new IIpsObjectPart[this.movedParts.size()]);
    }

    public boolean isAffected(IIpsObjectPartContainer partContainer) {
        if (partContainer == null) {
            return false;
        }
        if (partContainer == this.part || this.isAffectedIpsSrcFile(partContainer) || this.isChildOf(this.part, partContainer)) {
            return true;
        }
        if (this.movedParts == null) {
            return false;
        }
        for (IIpsObjectPart movedPart : this.movedParts) {
            if (movedPart != partContainer && !this.isChildOf(movedPart, partContainer)) continue;
            return true;
        }
        return false;
    }

    private boolean isAffectedIpsSrcFile(IIpsObjectPartContainer partContainer) {
        return partContainer.getIpsSrcFile() != null && partContainer.getIpsSrcFile().equals(this.ipsSrcFile) && this.type == 1;
    }

    private boolean isChildOf(IIpsObjectPartContainer potentialChild, IIpsObjectPartContainer potentialParent) {
        if (potentialChild == null) {
            return false;
        }
        IIpsElement parent = potentialChild.getParent();
        if (parent != null) {
            if (potentialParent.equals(parent)) {
                return true;
            }
            if (parent instanceof IIpsObjectPart) {
                return this.isChildOf((IIpsObjectPart)parent, potentialParent);
            }
        }
        return false;
    }

    public boolean isPropertyAffected(String propertyName) {
        if (this.propertyChangeEvents == null || propertyName == null) {
            return false;
        }
        for (PropertyChangeEvent propertyChangeEvent : this.propertyChangeEvents) {
            if (!propertyName.equals(propertyChangeEvent.getPropertyName())) continue;
            return true;
        }
        return false;
    }

    public boolean containsAffectedObjects(Class<?> type) {
        ArgumentCheck.notNull(type);
        if (this.part != null && type.isAssignableFrom(this.part.getClass())) {
            return true;
        }
        if (this.movedParts == null) {
            return false;
        }
        for (IIpsObjectPart movedPart : this.movedParts) {
            if (!type.isAssignableFrom(movedPart.getClass())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "ContentChangeEvent for " + this.ipsSrcFile;
    }

    public PropertyChangeEvent getFirstPropertyChangeEvent() {
        if (this.propertyChangeEvents.isEmpty()) {
            return null;
        }
        return this.propertyChangeEvents.iterator().next();
    }

    public Set<PropertyChangeEvent> getPropertyChangeEvents() {
        return Collections.unmodifiableSet(this.propertyChangeEvents);
    }
}

