/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.faktorips.devtools.abstraction.AContainer;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.AFolder;
import org.faktorips.devtools.abstraction.AJavaProject;
import org.faktorips.devtools.abstraction.APackageFragmentRoot;
import org.faktorips.devtools.abstraction.AProject;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.abstraction.util.PathUtil;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.Messages;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragment;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragmentRoot;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.IoUtil;

public class CreateIpsArchiveOperation
implements ICoreRunnable {
    private IIpsPackageFragmentRoot[] roots;
    private File archive;
    private boolean inclJavaSources;
    private boolean inclJavaBinaries;
    private Set<AFolder> handledRootFolders = new HashSet<AFolder>();
    private Set<String> handledEntries = new HashSet<String>(1000);

    public CreateIpsArchiveOperation(IIpsProject projectToArchive, File archive) {
        IIpsPackageFragmentRoot[] candidateRoots;
        this.archive = archive;
        ArrayList<IIpsPackageFragmentRoot> rootsInt = new ArrayList<IIpsPackageFragmentRoot>();
        IIpsPackageFragmentRoot[] iIpsPackageFragmentRootArray = candidateRoots = projectToArchive.getIpsPackageFragmentRoots();
        int n = candidateRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsPackageFragmentRoot candidateRoot = iIpsPackageFragmentRootArray[n2];
            if (candidateRoot.isBasedOnSourceFolder()) {
                rootsInt.add(candidateRoot);
            }
            ++n2;
        }
        this.roots = rootsInt.toArray(new IIpsPackageFragmentRoot[rootsInt.size()]);
    }

    public CreateIpsArchiveOperation(IIpsPackageFragmentRoot rootToArchive, File archive) {
        this(new IIpsPackageFragmentRoot[]{rootToArchive}, archive);
    }

    public CreateIpsArchiveOperation(IIpsPackageFragmentRoot[] rootsToArchive, File archive) {
        this.roots = rootsToArchive;
        this.archive = archive;
    }

    public void run(IProgressMonitor monitor) {
        JarOutputStream os;
        IProgressMonitor theMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)theMonitor, (String)Messages.CreateIpsArchiveOperation_Task_CreateArchive, (int)100);
        SubMonitor exportMonitor = subMonitor.split(98);
        exportMonitor.beginTask(null, this.getWorkload());
        AFile workspaceFile = this.getWorkspaceFile();
        if (workspaceFile != null && workspaceFile.getLocalTimeStamp() == this.archive.lastModified()) {
            try {
                Thread.sleep(1010L);
            }
            catch (InterruptedException e) {
                throw new IpsException((IStatus)new IpsStatus(e));
            }
        }
        try {
            os = new JarOutputStream(new FileOutputStream(this.archive));
        }
        catch (IOException e) {
            throw new IpsException((IStatus)new IpsStatus("Error opening output stream for jar file " + this.archive, e));
        }
        Properties ipsObjectsProperties = new Properties();
        IIpsPackageFragmentRoot[] iIpsPackageFragmentRootArray = this.roots;
        int n = this.roots.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsPackageFragmentRoot root = iIpsPackageFragmentRootArray[n2];
            SubMonitor subExportMonitor = exportMonitor.split(root.getIpsPackageFragments().length);
            this.addToArchive(root, os, ipsObjectsProperties, (IProgressMonitor)subExportMonitor);
            ++n2;
        }
        this.createIpsObjectsPropertiesEntry(os, ipsObjectsProperties);
        try {
            os.close();
        }
        catch (Exception e) {
            throw new IpsException((IStatus)new IpsStatus("Error closing output stream for jar file " + this.archive, e));
        }
        SubMonitor refreshMonitor = subMonitor.split(2);
        this.refreshInWorkspaceIfNecessary((IProgressMonitor)refreshMonitor);
    }

    private void refreshInWorkspaceIfNecessary(IProgressMonitor monitor) {
        AContainer parent;
        AFile fileInWorkspace = this.getWorkspaceFile();
        if (fileInWorkspace == null) {
            monitor.done();
            return;
        }
        if (fileInWorkspace.exists()) {
            fileInWorkspace.refreshLocal(AResource.AResourceTreeTraversalDepth.RESOURCE_ONLY, monitor);
        }
        if ((parent = fileInWorkspace.getParent()) != null) {
            parent.refreshLocal(AResource.AResourceTreeTraversalDepth.RESOURCE_AND_DIRECT_MEMBERS, monitor);
        }
    }

    private AFile getWorkspaceFile() {
        for (AProject project : Abstractions.getWorkspace().getRoot().getProjects()) {
            Path projectPath = project.getLocation();
            Path filePath = this.archive.getAbsoluteFile().toPath();
            if (!filePath.startsWith(projectPath)) continue;
            Path filePathInProject = projectPath.relativize(filePath);
            return project.getFile(filePathInProject);
        }
        return null;
    }

    private void addToArchive(IIpsPackageFragmentRoot root, JarOutputStream os, Properties ipsObjectsProperties, IProgressMonitor monitor) {
        IIpsPackageFragment[] packs = root.getIpsPackageFragments();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)packs.length);
        IIpsPackageFragment[] iIpsPackageFragmentArray = packs;
        int n = packs.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsPackageFragment pack = iIpsPackageFragmentArray[n2];
            this.addToArchive(pack, os, ipsObjectsProperties, (IProgressMonitor)subMonitor.split(1));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++n2;
        }
        if (this.inclJavaBinaries || this.inclJavaSources) {
            this.addJavaFiles(root, os, monitor);
        }
    }

    private void addToArchive(IIpsPackageFragment pack, JarOutputStream os, Properties ipsObjectsProperties, IProgressMonitor monitor) {
        try {
            IIpsElement[] elements = pack.getChildren();
            monitor.beginTask(null, elements.length);
            IIpsElement[] iIpsElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IIpsElement element = iIpsElementArray[n2];
                this.addToArchive((IIpsSrcFile)element, os, ipsObjectsProperties);
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean isDuplicateEntry(String entryName) {
        if (this.handledEntries.contains(entryName)) {
            return true;
        }
        this.handledEntries.add(entryName);
        return false;
    }

    private void addToArchive(IIpsSrcFile file, JarOutputStream os, Properties ipsObjectsProperties) {
        InputStream content = file.getContentFromEnclosingResource();
        Path qualifiedNamePath = file.getQualifiedNameType().toPath();
        String path = qualifiedNamePath == null ? "" : PathUtil.toPortableString((Path)qualifiedNamePath);
        String entryName = "ipsobjects/" + path;
        if (this.isDuplicateEntry(entryName)) {
            return;
        }
        this.writeJarEntry(os, content, entryName, file.getCorrespondingFile().getName());
        this.writeCustomIconIfApplicable(file, os);
        String basePackageProperty = String.valueOf(path) + "#" + "basePackageMergable";
        ipsObjectsProperties.setProperty(basePackageProperty, file.getBasePackageNameForMergableArtefacts());
        String extensionPackageProperty = String.valueOf(path) + "#" + "basePackageDerived";
        ipsObjectsProperties.setProperty(extensionPackageProperty, file.getBasePackageNameForDerivedArtefacts());
    }

    private void writeJarEntry(JarOutputStream os, InputStream content, String entryName, String fileName) {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            try {
                int nextByte;
                in = new BufferedInputStream(content);
                out = new BufferedOutputStream(os);
                JarEntry newEntry = new JarEntry(entryName);
                os.putNextEntry(newEntry);
                while ((nextByte = in.read()) != -1) {
                    out.write(nextByte);
                }
            }
            catch (IOException e) {
                throw new IpsException((IStatus)new IpsStatus("Error writing archive entry for file " + fileName, e));
            }
        }
        catch (Throwable throwable) {
            IoUtil.close(in);
            try {
                if (out != null) {
                    out.flush();
                }
            }
            catch (IOException e) {
                throw new IpsException((IStatus)new IpsStatus("Unable to flush steam.", e));
            }
            throw throwable;
        }
        IoUtil.close((Closeable)in);
        try {
            if (out != null) {
                out.flush();
            }
        }
        catch (IOException e) {
            throw new IpsException((IStatus)new IpsStatus("Unable to flush steam.", e));
        }
    }

    private void writeCustomIconIfApplicable(IIpsSrcFile file, JarOutputStream os) {
        String iconPath;
        if (file.getIpsObjectType() == IpsObjectType.PRODUCT_CMPT_TYPE && IpsStringUtils.isNotEmpty((String)(iconPath = file.getPropertyValue("instancesIcon")))) {
            if (this.isDuplicateEntry(iconPath)) {
                return;
            }
            InputStream iconStream = file.getIpsProject().getResourceAsStream(iconPath);
            if (iconStream != null) {
                this.writeJarEntry(os, iconStream, iconPath, iconPath);
            }
        }
    }

    private void createIpsObjectsPropertiesEntry(JarOutputStream os, Properties ipsObjectsProperties) {
        JarEntry newEntry = new JarEntry("ipsobjects/ipsobjects.properties");
        try {
            os.putNextEntry(newEntry);
            ipsObjectsProperties.store(os, null);
        }
        catch (IOException e) {
            throw new IpsException((IStatus)new IpsStatus("Error creating entry ipsobjects.properties", e));
        }
    }

    private void addJavaFiles(IIpsPackageFragmentRoot root, JarOutputStream os, IProgressMonitor monitor) {
        Path path;
        APackageFragmentRoot javaRoot = root.getArtefactDestination(false);
        if (javaRoot == null) {
            throw new IpsException((IStatus)new IpsStatus("Can't find file Java root for IPS root " + root.getName()));
        }
        if (this.inclJavaBinaries) {
            AFolder outFolder;
            AJavaProject javaProject;
            path = javaRoot.getOutputLocation();
            if (path == null && (javaProject = javaRoot.getJavaProject()) != null) {
                path = javaProject.getOutputLocation();
            }
            if (path != null && !this.handledRootFolders.contains(outFolder = Abstractions.getWorkspace().getRoot().getFolder(path))) {
                this.addFiles(outFolder, outFolder, os, monitor);
                this.handledRootFolders.add(outFolder);
            }
        }
        if (this.inclJavaSources) {
            path = javaRoot.getPath();
            AFolder srcFolder = Abstractions.getWorkspace().getRoot().getFolder(path);
            if (this.handledRootFolders.contains(srcFolder)) {
                return;
            }
            this.addFiles(srcFolder, srcFolder, os, monitor);
            this.handledRootFolders.add(srcFolder);
        }
    }

    private void addFiles(AFolder rootFolder, AFolder folder, JarOutputStream os, IProgressMonitor monitor) {
        for (AResource member : folder) {
            if (member instanceof AFile) {
                this.addFiles(rootFolder, (AFile)member, os);
                continue;
            }
            if (!(member instanceof AFolder)) continue;
            this.addFiles(rootFolder, (AFolder)member, os, monitor);
        }
    }

    private void addFiles(AFolder rootFolder, AFile fileToAdd, JarOutputStream os) {
        String name = PathUtil.toPortableString((Path)rootFolder.getWorkspaceRelativePath().relativize(fileToAdd.getWorkspaceRelativePath()));
        if (this.isDuplicateEntry(name)) {
            return;
        }
        JarEntry newEntry = new JarEntry(name);
        try {
            os.putNextEntry(newEntry);
            byte[] contents = this.getContent(fileToAdd.getContents());
            os.write(contents);
        }
        catch (IOException e) {
            throw new IpsException((IStatus)new IpsStatus("Error creating entry ipsobjects.properties", e));
        }
    }

    private byte[] getContent(InputStream contents) {
        try {
            byte[] content = new byte[contents.available()];
            contents.read(content);
            contents.close();
            return content;
        }
        catch (IOException e) {
            throw new IpsException((IStatus)new IpsStatus(e));
        }
    }

    private int getWorkload() {
        int load = 1;
        int i = 0;
        while (i < this.roots.length) {
            load = this.roots[i].getIpsPackageFragments().length;
            ++i;
        }
        return load;
    }

    public boolean isInclJavaBinaries() {
        return this.inclJavaBinaries;
    }

    public void setInclJavaBinaries(boolean inclJavaBinaries) {
        this.inclJavaBinaries = inclJavaBinaries;
    }

    public boolean isInclJavaSources() {
        return this.inclJavaSources;
    }

    public void setInclJavaSources(boolean inclJavaSources) {
        this.inclJavaSources = inclJavaSources;
    }
}

