/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model;

import java.util.EnumSet;
import org.faktorips.devtools.model.ipsproject.IIpsProject;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DependencyType {
    INSTANCEOF("instance of dependency"){

        @Override
        public EnumSet<DependencyType> getTransitiveTypes(IIpsProject ipsProject) {
            return EnumSet.of(INSTANCEOF);
        }
    }
    ,
    SUBTYPE("subtype dependency"){

        @Override
        public EnumSet<DependencyType> getTransitiveTypes(IIpsProject ipsProject) {
            return EnumSet.allOf(DependencyType.class);
        }
    }
    ,
    CONFIGUREDBY("configured by dependency"){

        @Override
        public EnumSet<DependencyType> getTransitiveTypes(IIpsProject ipsProject) {
            return EnumSet.of(SUBTYPE, INSTANCEOF);
        }
    }
    ,
    CONFIGURES("configures dependency"){

        @Override
        public EnumSet<DependencyType> getTransitiveTypes(IIpsProject ipsProject) {
            return EnumSet.of(SUBTYPE, INSTANCEOF);
        }
    }
    ,
    REFERENCE_COMPOSITION_MASTER_DETAIL("master to detail composition dependency"){

        @Override
        public EnumSet<DependencyType> getTransitiveTypes(IIpsProject ipsProject) {
            boolean containsAggregateRootBuilder = ipsProject.getIpsArtefactBuilderSet().containsAggregateRootBuilder();
            if (containsAggregateRootBuilder) {
                return EnumSet.of(REFERENCE_COMPOSITION_MASTER_DETAIL);
            }
            return EnumSet.noneOf(DependencyType.class);
        }
    }
    ,
    REFERENCE("reference dependency"){

        @Override
        public EnumSet<DependencyType> getTransitiveTypes(IIpsProject ipsProject) {
            return EnumSet.noneOf(DependencyType.class);
        }
    }
    ,
    DATATYPE("datatype dependency"){

        @Override
        public EnumSet<DependencyType> getTransitiveTypes(IIpsProject ipsProject) {
            return EnumSet.of(SUBTYPE, CONFIGURES, INSTANCEOF);
        }
    }
    ,
    VALIDATION("validation dependency"){

        @Override
        public EnumSet<DependencyType> getTransitiveTypes(IIpsProject ipsProject) {
            return EnumSet.noneOf(DependencyType.class);
        }
    };

    private String name;

    private DependencyType(String name) {
        this.name = name;
    }

    public abstract EnumSet<DependencyType> getTransitiveTypes(IIpsProject var1);

    public EnumSet<DependencyType> getNextTransitiveTypes(EnumSet<DependencyType> currentTransitiveTypes, IIpsProject ipsProject) {
        EnumSet<DependencyType> nextTransitiveTypes = EnumSet.copyOf(currentTransitiveTypes);
        nextTransitiveTypes.retainAll(this.getTransitiveTypes(ipsProject));
        return nextTransitiveTypes;
    }

    public String toString() {
        return this.name;
    }
}

