/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.util.ArgumentCheck;

public abstract class HierarchyVisitor<T> {
    private final IIpsProject ipsProject;
    private LinkedHashSet<T> visitedTypes;
    private boolean cycleDetected;

    public HierarchyVisitor(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject);
        this.ipsProject = ipsProject;
    }

    public boolean cycleDetected() {
        return this.cycleDetected;
    }

    public List<T> getVisited() {
        return Collections.unmodifiableList(new ArrayList<T>(this.visitedTypes));
    }

    public boolean isAlreadyVisited(T object) {
        return this.getVisited().contains(object);
    }

    public void start(T basetype) {
        this.cycleDetected = false;
        this.visitedTypes = new LinkedHashSet();
        if (basetype == null) {
            return;
        }
        this.visitInternal(basetype);
    }

    private void visitInternal(T currentType) {
        if (this.isAlreadyVisited(currentType)) {
            this.cycleDetected = true;
            return;
        }
        this.visitedTypes.add(currentType);
        boolean continueVisiting = this.visit(currentType);
        if (!continueVisiting) {
            return;
        }
        T supertype = this.findSupertype(currentType, this.ipsProject);
        if (supertype != null) {
            this.visitInternal(supertype);
        }
    }

    protected IIpsProject getIpsProject() {
        return this.ipsProject;
    }

    protected LinkedHashSet<T> getVisitedTypesAsSet() {
        return this.visitedTypes;
    }

    protected abstract T findSupertype(T var1, IIpsProject var2);

    protected abstract boolean visit(T var1);
}

