/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model;

import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.AbstractCustomValidation;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.productcmpt.IAttributeValue;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.Severity;

public abstract class SimpleCustomValidationForProductCmptAttributeValue
extends AbstractCustomValidation<IAttributeValue> {
    private String productCmptTypeName;
    private String attributeName;

    public SimpleCustomValidationForProductCmptAttributeValue(String attributeName) {
        this(null, attributeName);
    }

    public SimpleCustomValidationForProductCmptAttributeValue(String productCmptTypeName, String attributeName) {
        super(IAttributeValue.class);
        this.productCmptTypeName = productCmptTypeName;
        this.attributeName = attributeName;
    }

    public String getProductCmptTypeName() {
        return this.productCmptTypeName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public MessageList validate(IAttributeValue attribute, IIpsProject ipsProject) {
        if (!this.attributeName.equals(attribute.getAttribute()) || this.productCmptTypeName != null && !this.productCmptTypeName.equals(attribute.getPropertyValueContainer().getProductCmptType())) {
            return null;
        }
        try {
            ValidationResult result = this.validate(attribute.getPropertyValue(), ipsProject);
            if (result != null) {
                MessageList messages = new MessageList();
                Message msg = new Message(result.msgCode, result.text, result.severity, (Object)attribute, new String[]{"valueHolder"});
                messages.add(msg);
                return messages;
            }
        }
        catch (Exception e) {
            IpsLog.log(e);
        }
        return null;
    }

    @Override
    public String toString() {
        String type = this.productCmptTypeName == null ? "any" : this.productCmptTypeName;
        return "Custom validation for " + type + ". " + this.attributeName;
    }

    public abstract ValidationResult validate(String var1, IIpsProject var2) throws IpsException;

    public static ValidationResult newError(String code, String text) {
        return new ValidationResult(Message.ERROR, text, code);
    }

    public static ValidationResult newWarning(String code, String text) {
        return new ValidationResult(Message.WARNING, text, code);
    }

    public static ValidationResult newInfo(String code, String text) {
        return new ValidationResult(Message.INFO, text, code);
    }

    public static class ValidationResult {
        private Severity severity;
        private String text;
        private String msgCode;

        ValidationResult(Severity warning, String text, String msgCode) {
            this.severity = warning;
            this.text = text;
            this.msgCode = msgCode;
        }
    }
}

