/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.abstractions;

import java.io.File;
import java.util.Comparator;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.faktorips.devtools.abstraction.AProject;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.abstractions.AWorkspaceAbstractionsImplementationProvider;
import org.faktorips.devtools.model.internal.IpsModel;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPath;
import org.faktorips.devtools.model.internal.ipsproject.IpsProject;
import org.faktorips.devtools.model.ipsproject.IIpsArchive;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPathEntry;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.IIpsProjectProperties;
import org.faktorips.devtools.model.plugin.IpsModelActivator;

public final class WorkspaceAbstractions {
    private static final AWorkspaceAbstractionsImplementation IMPLEMENTATION = WorkspaceAbstractions.get();

    private WorkspaceAbstractions() {
    }

    private static AWorkspaceAbstractionsImplementation get() {
        IpsModelActivator osgiProvider = IpsModelActivator.get();
        if (osgiProvider != null) {
            return osgiProvider.getWorkspaceAbstractionsImplementation();
        }
        Optional<AWorkspaceAbstractionsImplementationProvider> implementationProvider = ServiceLoader.load(AWorkspaceAbstractionsImplementationProvider.class).stream().map(ServiceLoader.Provider::get).sorted(Comparator.comparing(AWorkspaceAbstractionsImplementationProvider::getPriority).reversed()).findFirst();
        return implementationProvider.orElseThrow(() -> new IpsException("No workspace abstractions implementation provider found!")).getWorkspaceAbstractionsImplementation();
    }

    public static IpsModel createIpsModel() {
        return IMPLEMENTATION.createIpsModel();
    }

    public static IpsProject createIpsProject(IIpsModel ipsModel, String name) {
        return IMPLEMENTATION.createIpsProject(ipsModel, name);
    }

    public static IIpsProject createIpsProject(IIpsModel ipsModel, AProject project) {
        return IMPLEMENTATION.createIpsProject(ipsModel, project);
    }

    public static void addRequiredEntriesToIpsObjectPath(IpsObjectPath ipsObjectPath, Consumer<IIpsObjectPathEntry> entryAdder) {
        IMPLEMENTATION.addRequiredEntriesToIpsObjectPath(ipsObjectPath, entryAdder);
    }

    public static File getFileFromArchivePath(IIpsArchive ipsArchive) {
        return IMPLEMENTATION.getFileFromArchivePath(ipsArchive);
    }

    public static IIpsModelExtensions getIpsModelExtensions() {
        return IMPLEMENTATION.getIpsModelExtensions();
    }

    public static interface AWorkspaceAbstractionsImplementation {
        public IpsModel createIpsModel();

        default public IpsProject createIpsProject(IIpsModel ipsModel, String name) {
            return new IpsProject(ipsModel, name);
        }

        default public IIpsProject createIpsProject(IIpsModel ipsModel, AProject project) {
            if (project.isIpsProject()) {
                return ipsModel.getIpsProject(project);
            }
            IIpsProject ipsProject = ipsModel.getIpsProject(project);
            this.initializeProject(ipsProject);
            return ipsProject;
        }

        default public void initializeProject(IIpsProject ipsProject) {
            IIpsProjectProperties props = ipsProject.getProperties();
            this.initializeProperties(props);
            ipsProject.setProperties(props);
        }

        default public void initializeProperties(IIpsProjectProperties props) {
        }

        public void addRequiredEntriesToIpsObjectPath(IpsObjectPath var1, Consumer<IIpsObjectPathEntry> var2);

        default public File getFileFromArchivePath(IIpsArchive ipsArchive) {
            return ipsArchive.getLocation().toFile();
        }

        public IIpsModelExtensions getIpsModelExtensions();
    }
}

