/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.builder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.faktorips.datatype.util.LocalizedStringsSet;
import org.faktorips.devtools.abstraction.ABuildKind;
import org.faktorips.devtools.abstraction.AContainer;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.AFolder;
import org.faktorips.devtools.abstraction.APackageFragmentRoot;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilder;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilderSet;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.util.ArgumentCheck;

public abstract class AbstractArtefactBuilder
implements IIpsArtefactBuilder {
    private IIpsArtefactBuilderSet builderSet;
    private final LocalizedStringsSet localizedStringsSet;

    public AbstractArtefactBuilder(IIpsArtefactBuilderSet builderSet) {
        this(builderSet, null);
    }

    public AbstractArtefactBuilder(IIpsArtefactBuilderSet builderSet, LocalizedStringsSet localizedStringsSet) {
        this.builderSet = builderSet;
        this.localizedStringsSet = localizedStringsSet;
    }

    @Override
    public IIpsArtefactBuilderSet getBuilderSet() {
        return this.builderSet;
    }

    public IIpsProject getIpsProject() {
        return this.builderSet.getIpsProject();
    }

    @Override
    public void beforeBuildProcess(IIpsProject project, ABuildKind buildKind) {
    }

    @Override
    public void afterBuildProcess(IIpsProject project, ABuildKind buildKind) {
    }

    @Override
    public void beforeBuild(IIpsSrcFile ipsSrcFile, MultiStatus status) {
    }

    @Override
    public void afterBuild(IIpsSrcFile ipsSrcFile) {
    }

    @Override
    public boolean buildsDerivedArtefacts() {
        return false;
    }

    public String toString() {
        return "Builder: " + this.getName();
    }

    protected boolean createFileIfNotThere(AFile file) {
        ArgumentCheck.notNull((Object)file, (Object)this);
        if (!file.exists()) {
            AContainer parent = file.getParent();
            if (parent instanceof AFolder) {
                this.createFolderIfNotThere((AFolder)parent);
            }
            file.create((InputStream)new ByteArrayInputStream("".getBytes()), null);
            file.setDerived(this.buildsDerivedArtefacts() && this.getBuilderSet().isMarkNoneMergableResourcesAsDerived(), null);
            return true;
        }
        return false;
    }

    protected boolean createFolderIfNotThere(AFolder folder) {
        ArgumentCheck.notNull((Object)folder, (Object)this);
        if (!folder.exists()) {
            AContainer parent = folder.getParent();
            if (parent instanceof AFolder) {
                this.createFolderIfNotThere((AFolder)parent);
            }
            folder.create(null);
            folder.setDerived(this.buildsDerivedArtefacts() && this.getBuilderSet().isMarkNoneMergableResourcesAsDerived(), null);
            return true;
        }
        return false;
    }

    public final Locale getLanguageUsedInGeneratedSourceCode() {
        return this.getBuilderSet().getLanguageUsedInGeneratedSourceCode();
    }

    public String getLocalizedText(String key) {
        if (this.localizedStringsSet == null) {
            throw new RuntimeException("A LocalizedStringSet has to be set to this builder to be able to call this method.");
        }
        return this.getLocalizedStringSet().getString(key, this.getLanguageUsedInGeneratedSourceCode());
    }

    protected LocalizedStringsSet getLocalizedStringSet() {
        return this.localizedStringsSet;
    }

    public String getLocalizedText(String key, Object replacement) {
        if (this.localizedStringsSet == null) {
            throw new RuntimeException("A LocalizedStringSet has to be set to this builder to be able to call this method.");
        }
        return this.getLocalizedStringSet().getString(key, this.getLanguageUsedInGeneratedSourceCode(), new Object[]{replacement});
    }

    public String getLocalizedText(String key, Object ... replacements) {
        if (this.localizedStringsSet == null) {
            throw new RuntimeException("A LocalizedStringSet has to be set to this builder to be able to call this method.");
        }
        return this.getLocalizedStringSet().getString(key, this.getLanguageUsedInGeneratedSourceCode(), replacements);
    }

    public void writeToFile(AFile file, InputStream inputStream, boolean keepHistory) {
        file.setContents(inputStream, keepHistory, (IProgressMonitor)new NullProgressMonitor());
    }

    protected APackageFragmentRoot getArtefactDestination(IIpsSrcFile ipsSrcFile) {
        return ipsSrcFile.getIpsPackageFragment().getRoot().getArtefactDestination(this.buildsDerivedArtefacts());
    }
}

