/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.builder;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.faktorips.devtools.abstraction.ABuildKind;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.ipsproject.IBuilderKindId;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilder;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilderSet;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilderSetConfig;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.util.ArgumentCheck;

public abstract class AbstractBuilderSet
implements IIpsArtefactBuilderSet {
    public static final String CONFIG_PROPERTY_GENERATOR_LOCALE = "generatorLocale";
    public static final String CONFIG_MARK_NONE_MERGEABLE_RESOURCES_AS_DERIVED = "markNoneMergeableResourcesAsDerived";
    private String id;
    private String label;
    private IIpsProject ipsProject;
    private IIpsArtefactBuilderSetConfig config;
    private LinkedHashMap<IBuilderKindId, IIpsArtefactBuilder> builders;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public IIpsProject getIpsProject() {
        return this.ipsProject;
    }

    @Override
    public void setIpsProject(IIpsProject ipsProject) {
        this.ipsProject = ipsProject;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public boolean containsAggregateRootBuilder() {
        return false;
    }

    @Override
    public boolean isInverseRelationLinkRequiredFor2WayCompositions() {
        return false;
    }

    @Override
    public boolean isRoleNamePluralRequiredForTo1Relations() {
        return false;
    }

    @Override
    public IIpsArtefactBuilder[] getArtefactBuilders() {
        return this.builders.values().toArray(new IIpsArtefactBuilder[this.builders.size()]);
    }

    @Override
    public IIpsArtefactBuilderSetConfig getConfig() {
        return this.config;
    }

    @Override
    public void initialize(IIpsArtefactBuilderSetConfig config) {
        ArgumentCheck.notNull((Object)config);
        this.config = config;
        this.builders = this.createBuilders();
    }

    @Override
    public Locale getLanguageUsedInGeneratedSourceCode() {
        String localeString = this.getConfig().getPropertyValueAsString(CONFIG_PROPERTY_GENERATOR_LOCALE);
        if (localeString == null) {
            return Locale.ENGLISH;
        }
        return AbstractBuilderSet.getLocale(localeString);
    }

    public static Locale getLocale(String s) {
        StringTokenizer tokenzier = new StringTokenizer(s, "_");
        if (!tokenzier.hasMoreTokens()) {
            return Locale.ENGLISH;
        }
        String language = tokenzier.nextToken();
        if (!tokenzier.hasMoreTokens()) {
            return new Locale(language);
        }
        String country = tokenzier.nextToken();
        if (!tokenzier.hasMoreTokens()) {
            return new Locale(language, country);
        }
        String variant = tokenzier.nextToken();
        return new Locale(language, country, variant);
    }

    protected abstract LinkedHashMap<IBuilderKindId, IIpsArtefactBuilder> createBuilders() throws IpsException;

    @Override
    public void afterBuildProcess(ABuildKind buildKind) {
    }

    @Override
    public void beforeBuildProcess(ABuildKind buildKind) {
    }

    @Override
    public <T extends IIpsArtefactBuilder> List<T> getBuildersByClass(Class<T> builderClass) {
        if (this.builders == null) {
            throw new IllegalStateException("No builders initialized yet");
        }
        ArrayList<IIpsArtefactBuilder> buildersByClass = new ArrayList<IIpsArtefactBuilder>();
        for (IIpsArtefactBuilder builder : this.builders.values()) {
            if (!builderClass.isAssignableFrom(builder.getClass())) continue;
            IIpsArtefactBuilder castedBuilder = builder;
            buildersByClass.add(castedBuilder);
        }
        return buildersByClass;
    }

    @Override
    public IIpsArtefactBuilder getBuilderById(IBuilderKindId kindId) {
        IIpsArtefactBuilder builder = this.builders.get(kindId);
        if (builder == null) {
            throw new RuntimeException("There is no builder for the kind ID: " + kindId);
        }
        return builder;
    }

    @Override
    public <T extends IIpsArtefactBuilder> T getBuilderById(IBuilderKindId kindId, Class<T> builderClass) {
        IIpsArtefactBuilder builderById = this.getBuilderById(kindId);
        if (builderClass.isAssignableFrom(builderById.getClass())) {
            return this.castBuilder(builderById);
        }
        throw new RuntimeException("There is no builder for kind ID: " + kindId + " of the type: " + builderClass);
    }

    private <T extends IIpsArtefactBuilder> T castBuilder(IIpsArtefactBuilder builderById) {
        return (T)builderById;
    }

    @Override
    public boolean isTableBasedEnumValidationRequired() {
        return true;
    }

    @Override
    public boolean isMarkNoneMergableResourcesAsDerived() {
        Boolean propertyValueAsBoolean = this.getConfig().getPropertyValueAsBoolean(CONFIG_MARK_NONE_MERGEABLE_RESOURCES_AS_DERIVED);
        if (propertyValueAsBoolean != null) {
            return propertyValueAsBoolean;
        }
        return true;
    }

    @Override
    public void clean(IProgressMonitor monitor) {
    }
}

