/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.builder;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.devtools.abstraction.ABuildKind;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.AFolder;
import org.faktorips.devtools.abstraction.util.PathUtil;
import org.faktorips.devtools.model.builder.AbstractBuilderSet;
import org.faktorips.devtools.model.builder.IJavaPackageStructure;
import org.faktorips.devtools.model.builder.IPersistenceProvider;
import org.faktorips.devtools.model.builder.naming.JavaPackageStructure;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragmentRoot;
import org.faktorips.devtools.model.ipsproject.IIpsSrcFolderEntry;
import org.faktorips.devtools.model.productcmpt.IExpression;
import org.faktorips.devtools.model.tablestructure.ITableAccessFunction;
import org.faktorips.devtools.model.util.QNameUtil;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.ExprCompiler;
import org.faktorips.fl.IdentifierResolver;

public abstract class DefaultBuilderSet
extends AbstractBuilderSet
implements IJavaPackageStructure {
    private static final String PARENTHESIS_CHARACTER = "(";
    private static final String SEMI_COLON_CHARACTER = ";";
    private JavaPackageStructure javaPackageStructure = new JavaPackageStructure();
    private List<String> additionalAnnotations = new ArrayList<String>();
    private List<String> additionalImports = new ArrayList<String>();
    private List<String> retainedAnnotations = new ArrayList<String>();

    @Override
    public AFile getRuntimeRepositoryTocFile(IIpsPackageFragmentRoot root) {
        if (root == null || !root.isBasedOnSourceFolder()) {
            return null;
        }
        IIpsSrcFolderEntry entry = (IIpsSrcFolderEntry)root.getIpsObjectPathEntry();
        String basePackInternal = this.javaPackageStructure.getBasePackageName(entry, true, false);
        Path path = QNameUtil.toPath(basePackInternal);
        String basePackageRelativeTocPath = this.getRelativePath(entry);
        path = path == null ? Path.of(basePackageRelativeTocPath, new String[0]) : path.resolve(basePackageRelativeTocPath);
        AFolder tocFileLocation = this.getTocFileLocation(root);
        if (tocFileLocation == null) {
            return null;
        }
        return tocFileLocation.getFile(path);
    }

    private String getRelativePath(IIpsSrcFolderEntry entry) {
        String basePackageRelativeTocPath = entry.getBasePackageRelativeTocPath();
        if (basePackageRelativeTocPath.startsWith("/") || basePackageRelativeTocPath.startsWith("\\")) {
            basePackageRelativeTocPath = basePackageRelativeTocPath.substring(1);
        }
        return basePackageRelativeTocPath;
    }

    private AFolder getTocFileLocation(IIpsPackageFragmentRoot root) {
        IIpsSrcFolderEntry entry = (IIpsSrcFolderEntry)root.getIpsObjectPathEntry();
        return entry.getOutputFolderForDerivedJavaFiles();
    }

    @Override
    public String getRuntimeRepositoryTocResourceName(IIpsPackageFragmentRoot root) {
        AFile tocFile = this.getRuntimeRepositoryTocFile(root);
        if (tocFile == null) {
            return null;
        }
        AFolder tocFileLocation = this.getTocFileLocation(root);
        return PathUtil.toPortableString((Path)tocFileLocation.getWorkspaceRelativePath().relativize(tocFile.getWorkspaceRelativePath()));
    }

    @Override
    public String getPackageName(IIpsSrcFile ipsSrcFile, boolean internalArtifacts, boolean mergableArtifacts) {
        return this.javaPackageStructure.getPackageName(ipsSrcFile, internalArtifacts, mergableArtifacts);
    }

    @Override
    public String getBasePackageName(IIpsSrcFolderEntry entry, boolean internalArtifacts, boolean mergableArtifacts) {
        return this.javaPackageStructure.getBasePackageName(entry, internalArtifacts, mergableArtifacts);
    }

    public abstract boolean isGeneratePublishedInterfaces();

    @Override
    public boolean isSupportTableAccess() {
        return false;
    }

    @Override
    public CompilationResult<JavaCodeFragment> getTableAccessCode(String tableContentsQualifiedName, ITableAccessFunction fct, CompilationResult<JavaCodeFragment>[] argResults) {
        return null;
    }

    @Override
    public boolean isSupportFlIdentifierResolver() {
        return false;
    }

    @Override
    public IdentifierResolver<JavaCodeFragment> createFlIdentifierResolver(IExpression formula, ExprCompiler<JavaCodeFragment> exprCompiler) {
        return null;
    }

    @Override
    public String getVersion() {
        return "";
    }

    @Override
    public IPersistenceProvider getPersistenceProvider() {
        return null;
    }

    @Override
    public void beforeBuildProcess(ABuildKind buildKind) {
        super.beforeBuildProcess(buildKind);
        this.initAdditionalAnnotationsAndImports();
        this.retainedAnnotations = this.initRetainedAnnotations();
    }

    protected String getConfiguredAdditionalAnnotations() {
        return "";
    }

    protected String getConfiguredRetainedAnnotations() {
        return "";
    }

    private List<String> splitString(String input) {
        String[] split;
        ArrayList<String> splitInput = new ArrayList<String>();
        String[] stringArray = split = input.split(SEMI_COLON_CHARACTER);
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            splitInput.add(string.trim());
            ++n2;
        }
        return splitInput;
    }

    private void initAdditionalAnnotationsAndImports() {
        this.additionalAnnotations = new LinkedList<String>();
        this.additionalImports = new LinkedList<String>();
        HashSet<String> unqualifiedNames = new HashSet<String>();
        List<String> splitInput = this.splitString(this.getConfiguredAdditionalAnnotations());
        for (String splitString : splitInput) {
            String qualifiedName;
            String unqualifiedName;
            int i = splitString.indexOf(PARENTHESIS_CHARACTER);
            if (i < 0) {
                i = splitString.length();
            }
            String nameForAnnotation = unqualifiedNames.contains(unqualifiedName = QNameUtil.getUnqualifiedName(qualifiedName = splitString.substring(0, i))) ? qualifiedName : unqualifiedName;
            unqualifiedNames.add(unqualifiedName);
            if (!qualifiedName.equals(nameForAnnotation)) {
                this.additionalImports.add(qualifiedName);
            }
            this.additionalAnnotations.add(String.valueOf(nameForAnnotation) + splitString.substring(i));
        }
    }

    private List<String> initRetainedAnnotations() {
        List<String> annotations = this.splitString(this.getConfiguredRetainedAnnotations());
        ListIterator<String> iterator = annotations.listIterator();
        while (iterator.hasNext()) {
            String annotation = iterator.next();
            if (annotation.startsWith("@")) continue;
            iterator.set(String.valueOf('@') + annotation);
        }
        return annotations;
    }

    public List<String> getAdditionalImports() {
        return this.additionalImports;
    }

    public List<String> getAdditionalAnnotations() {
        return this.additionalAnnotations;
    }

    public String getAdditionalAnnotationsLocation() {
        return "";
    }

    public List<String> getRetainedAnnotations() {
        return this.retainedAnnotations;
    }
}

