/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.builder;

import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.faktorips.devtools.abstraction.ABuildKind;
import org.faktorips.devtools.abstraction.ABuilder;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.AFolder;
import org.faktorips.devtools.abstraction.AMarker;
import org.faktorips.devtools.abstraction.APackageFragmentRoot;
import org.faktorips.devtools.abstraction.AProject;
import org.faktorips.devtools.abstraction.AResource;
import org.faktorips.devtools.abstraction.AResourceDelta;
import org.faktorips.devtools.abstraction.AResourceDeltaVisitor;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.builder.IDependencyGraph;
import org.faktorips.devtools.model.builder.Messages;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.internal.builder.DependencyResolver;
import org.faktorips.devtools.model.internal.ipsobject.IpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsArchiveEntry;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilder;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilderSet;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPath;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPathContainer;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPathEntry;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragment;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragmentRoot;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.IIpsSrcFolderEntry;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.Severity;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.MultiMap;

public class IpsBuilder {
    public static final String BUILDER_ID = "org.faktorips.devtools.model.eclipse.ipsbuilder";
    public static final String PROBLEM_MARKER = "org.faktorips.devtools.model.eclipse.problemmarker";
    public static final boolean TRACE_BUILDER_TRACE;
    private static final String BUILD_ERROR_MSG_CODE = "BUILD_ERROR";
    private static final Pattern EXCEPTION_WHILE_BUILDING_REGEX;
    private final ABuilder builder;
    private Map<String, Long> lastModificationTimestampForBuilderSets = new HashMap<String, Long>();

    static {
        EXCEPTION_WHILE_BUILDING_REGEX = Pattern.compile("^(\\w+): Error during: (?:Build file|Delete file) ([\\w\\W]+).$", 32);
        TRACE_BUILDER_TRACE = Boolean.parseBoolean(Abstractions.getDebugOption((String)"org.faktorips.devtools.model/trace/builder"));
    }

    public IpsBuilder(ABuilder builder) {
        this.builder = builder;
    }

    private MultiStatus createInitialMultiStatus() {
        return new MultiStatus("org.faktorips.devtools.model", 0, Messages.IpsBuilder_msgBuildResults, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<AProject> build(ABuildKind kind, IProgressMonitor monitor) {
        ABuildKind currentKind = kind;
        MultiStatus buildStatus = this.createInitialMultiStatus();
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"build", (int)100000);
            subMonitor.subTask(Messages.IpsBuilder_validatingProject);
            this.getIpsProject().getIpsModel().clearValidationCache();
            if (!this.checkIpsProjectBeforeBuild(this.getIpsProject())) {
                return null;
            }
            subMonitor.worked(100);
            subMonitor.subTask(Messages.IpsBuilder_preparingBuild);
            IIpsArtefactBuilderSet ipsArtefactBuilderSet = this.getBuilderSetReInitialisedIfNecessary(this.getIpsProject());
            boolean isFullBuildRequired = this.isFullBuildRequired(currentKind);
            if (isFullBuildRequired) {
                currentKind = ABuildKind.FULL;
            }
            this.beforeBuildForBuilderSet(ipsArtefactBuilderSet, buildStatus, currentKind);
            this.applyBuildCommand(ipsArtefactBuilderSet, buildStatus, new BeforeBuildProcessCommand(currentKind, this.getIpsProject()), (IProgressMonitor)subMonitor);
            subMonitor.worked(100);
            try {
                if (isFullBuildRequired) {
                    currentKind = ABuildKind.FULL;
                    subMonitor.subTask(Messages.IpsBuilder_startFullBuild);
                    this.fullBuild(ipsArtefactBuilderSet, buildStatus, (IProgressMonitor)subMonitor.split(9970));
                } else {
                    subMonitor.subTask(Messages.IpsBuilder_startIncrementalBuild);
                    this.incrementalBuild(ipsArtefactBuilderSet, buildStatus, (IProgressMonitor)subMonitor.split(9970));
                }
            }
            finally {
                subMonitor.subTask(Messages.IpsBuilder_finishBuild);
                this.applyBuildCommand(ipsArtefactBuilderSet, buildStatus, new AfterBuildProcessCommand(currentKind, this.getIpsProject()), (IProgressMonitor)subMonitor);
                this.afterBuildForBuilderSet(ipsArtefactBuilderSet, buildStatus, currentKind);
            }
            subMonitor.worked(100);
            if (buildStatus.getSeverity() == 0) {
                return this.builder.getProject().getReferencedProjects();
            }
            MultiStatus actualStatus = buildStatus;
            while (true) {
                MultiStatus multiStatus;
                block18: {
                    block17: {
                        MultiStatus multiStatus2;
                        if (!((multiStatus2 = actualStatus) instanceof MultiStatus)) break block17;
                        if (multiStatus.getChildren().length == 1) break block18;
                    }
                    Abstractions.getLog().log((IStatus)actualStatus);
                    this.getIpsProject().reinitializeIpsArtefactBuilderSet();
                    this.createMarkersFromBuildStatus((IStatus)actualStatus, PROBLEM_MARKER);
                    throw new CoreException((IStatus)actualStatus);
                }
                actualStatus = multiStatus.getChildren()[0];
            }
        }
        catch (OperationCanceledException e) {
            this.getIpsProject().reinitializeIpsArtefactBuilderSet();
            return this.builder.getProject().getReferencedProjects();
        }
        catch (CoreException e) {
            throw new IpsException(e);
        }
        catch (Throwable t) {
            throw new IpsException((IStatus)new IpsStatus(t));
        }
    }

    public void createMarkersFromBuildStatus(IStatus buildStatus, String markerType) {
        HashMap<AResource, MessageList> errors = new HashMap<AResource, MessageList>();
        for (IpsStatus ipsStatus : this.getIpsErrors(buildStatus)) {
            if (ipsStatus.getMessage().contains("BuildProcessCmd[kind=")) {
                this.preOrPostBuildErrors(errors, ipsStatus);
                continue;
            }
            Matcher regexMatcher = EXCEPTION_WHILE_BUILDING_REGEX.matcher(ipsStatus.getMessage());
            if (!regexMatcher.find()) continue;
            this.buildOrDeleteErrors(errors, ipsStatus, regexMatcher);
        }
        errors.forEach((resource, ml) -> {
            ml.wrapUpMessages(BUILD_ERROR_MSG_CODE);
            this.createMarkersFromMessageList((AResource)resource, (MessageList)ml, markerType);
        });
    }

    private void buildOrDeleteErrors(Map<AResource, MessageList> errors, IpsStatus ipsStatus, Matcher regexMatcher) {
        String builderName = regexMatcher.group(1);
        String ipsSrcFile = regexMatcher.group(2);
        AResource member = this.getIpsProject().getProject().getWorkspace().getRoot().findMember(ipsSrcFile);
        if (member != null) {
            MessageList ml = errors.computeIfAbsent(member, $ -> new MessageList());
            if (ipsStatus.getException() != null) {
                ml.add(Message.newError((String)BUILD_ERROR_MSG_CODE, (String)MessageFormat.format(Messages.IpsBuilder_msgExceptionWhileBuildingWithFile, builderName, this.extractExceptionMessage(ipsStatus.getException()))));
            } else {
                ml.add(Message.newError((String)BUILD_ERROR_MSG_CODE, (String)ipsStatus.getMessage()));
            }
        }
    }

    private void preOrPostBuildErrors(Map<AResource, MessageList> errors, IpsStatus ipsStatus) {
        MessageList ml = errors.computeIfAbsent((AResource)this.getIpsProject().getProject(), $ -> new MessageList());
        if (ipsStatus.getException() != null) {
            ml.add(Message.newError((String)BUILD_ERROR_MSG_CODE, (String)MessageFormat.format(Messages.IpsBuilder_msgExceptionWhileBuilding, this.extractExceptionMessage(ipsStatus.getException()))));
        } else {
            ml.add(Message.newError((String)BUILD_ERROR_MSG_CODE, (String)ipsStatus.getMessage()));
        }
    }

    private String extractExceptionMessage(Throwable exception) {
        return IpsStringUtils.isNotBlank((String)exception.getMessage()) ? exception.getMessage() : exception.getClass().getName();
    }

    /*
     * WARNING - void declaration
     */
    private List<IpsStatus> getIpsErrors(IStatus buildStatus) {
        Object status;
        ArrayList<IpsStatus> errors = new ArrayList<IpsStatus>();
        IStatus[] iStatusArray = buildStatus.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            status = iStatusArray[n2];
            errors.addAll(this.getIpsErrors((IStatus)status));
            ++n2;
        }
        IStatus iStatus = buildStatus;
        if (iStatus instanceof IpsStatus) {
            void ipsError;
            status = (IpsStatus)iStatus;
            IpsStatus cfr_ignored_0 = (IpsStatus)iStatus;
            errors.add((IpsStatus)ipsError);
        }
        return errors;
    }

    private IIpsArtefactBuilderSet getBuilderSetReInitialisedIfNecessary(IIpsProject project) {
        Long timestamp = this.lastModificationTimestampForBuilderSets.get(project.getName());
        if (timestamp == null) {
            this.lastModificationTimestampForBuilderSets.put(project.getName(), project.getReadOnlyProperties().getLastPersistentModificationTimestamp());
            return project.getIpsArtefactBuilderSet();
        }
        Long projectTimestamp = project.getReadOnlyProperties().getLastPersistentModificationTimestamp();
        if (!timestamp.equals(projectTimestamp)) {
            project.reinitializeIpsArtefactBuilderSet();
            this.lastModificationTimestampForBuilderSets.put(project.getName(), projectTimestamp);
        }
        return project.getIpsArtefactBuilderSet();
    }

    private boolean checkIpsProjectBeforeBuild(IIpsProject ipsProject) {
        ipsProject.getProject().deleteMarkers(PROBLEM_MARKER, true, AResource.AResourceTreeTraversalDepth.RESOURCE_ONLY);
        try {
            MessageList list = ipsProject.validate();
            AFile markedResource = ipsProject.getIpsProjectPropertiesFile();
            if (!markedResource.exists()) {
                markedResource = ipsProject.getProject();
                this.createMarkersFromMessageList((AResource)markedResource, list, PROBLEM_MARKER);
            } else {
                this.createMarkersForIpsProjectProperties(list, ipsProject);
            }
            if (list.containsErrorMsg()) {
                AMarker marker = markedResource.createMarker(PROBLEM_MARKER);
                String msg = Messages.IpsBuilder_msgInvalidProperties;
                this.updateMarker(marker, msg, 2);
                return false;
            }
        }
        catch (IpsException e) {
            IpsLog.log(e);
            return false;
        }
        return true;
    }

    public void createMarkersForIpsProjectProperties(MessageList messages, IIpsProject ipsProject) {
        AFile projectPropertiesFile = ipsProject.getIpsProjectPropertiesFile();
        IIpsObjectPath ipsObjectPath = ipsProject.getReadOnlyProperties().getIpsObjectPath();
        AFile manifest = ipsProject.getProject().getFile("META-INF/MANIFEST.MF");
        if (ipsObjectPath.isUsingManifest()) {
            if (manifest.exists()) {
                this.createMarkersForIpsProjectPropertiesAndManifest(messages, (AResource)projectPropertiesFile, manifest);
            } else {
                this.createMarkersWithMissingManifestMarker(messages, (AResource)projectPropertiesFile);
            }
        } else {
            this.createMarkersNotUsingManifest(messages, (AResource)projectPropertiesFile, manifest);
        }
    }

    private void createMarkersNotUsingManifest(MessageList messages, AResource projectPropertiesFile, AFile manifest) {
        this.createMarkersFromMessageList(projectPropertiesFile, messages, PROBLEM_MARKER);
        if (manifest.exists()) {
            manifest.deleteMarkers(PROBLEM_MARKER, true, AResource.AResourceTreeTraversalDepth.RESOURCE_ONLY);
        }
    }

    private void createMarkersWithMissingManifestMarker(MessageList messages, AResource projectPropertiesFile) {
        this.createMarkersFromMessageList(projectPropertiesFile, messages, PROBLEM_MARKER);
        AMarker marker = projectPropertiesFile.createMarker(PROBLEM_MARKER);
        String msg = MessageFormat.format(Messages.IpsBuilder_missingManifestMf, "META-INF/MANIFEST.MF");
        this.updateMarker(marker, msg, 2);
    }

    private void createMarkersForIpsProjectPropertiesAndManifest(MessageList messages, AResource projectPropertiesFile, AFile manifest) {
        MessageList messagesIpsObjectPath = new MessageList();
        MessageList messagesProject = new MessageList();
        for (Message message : messages) {
            if (this.isRelateToIpsObjectPath(message)) {
                messagesIpsObjectPath.add(message);
                continue;
            }
            messagesProject.add(message);
        }
        this.createMarkersFromMessageList(projectPropertiesFile, messagesProject, PROBLEM_MARKER);
        this.createMarkersFromMessageList((AResource)manifest, messagesIpsObjectPath, PROBLEM_MARKER);
    }

    private boolean isRelateToIpsObjectPath(Message message) {
        List objectProperties = message.getInvalidObjectProperties();
        for (ObjectProperty objectProperty : objectProperties) {
            Object object = objectProperty.getObject();
            if (!(object instanceof IIpsObjectPath) && !(object instanceof IIpsObjectPathEntry) && !(object instanceof IIpsObjectPathContainer)) continue;
            return true;
        }
        return false;
    }

    private boolean isFullBuildRequired(ABuildKind currentKind) {
        IIpsArchiveEntry[] entries;
        if (currentKind == ABuildKind.FULL) {
            return true;
        }
        AResourceDelta delta = this.builder.getDelta();
        if (delta == null) {
            return true;
        }
        IIpsProject ipsProject = this.getIpsProject();
        if (delta.findMember(ipsProject.getIpsProjectPropertiesFile().getProjectRelativePath()) != null || delta.findMember(Path.of("META-INF/MANIFEST.MF", new String[0])) != null) {
            return true;
        }
        IIpsArchiveEntry[] iIpsArchiveEntryArray = entries = ipsProject.getReadOnlyProperties().getIpsObjectPath().getArchiveEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsArchiveEntry entry = iIpsArchiveEntryArray[n2];
            if (entry.isAffectedBy(delta)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isBuilderEnabled() {
        return IIpsModelExtensions.get().getModelPreferences().isBuilderEnabled();
    }

    private void beforeBuildForBuilderSet(IIpsArtefactBuilderSet builderSet, MultiStatus buildStatus, ABuildKind buildKind) {
        if (!this.isBuilderEnabled()) {
            return;
        }
        try {
            builderSet.beforeBuildProcess(buildKind);
        }
        catch (Exception e) {
            buildStatus.add((IStatus)new IpsStatus("Error during beforeBuildProcess() of the builder set: " + builderSet.getId(), e));
        }
    }

    private void afterBuildForBuilderSet(IIpsArtefactBuilderSet builderSet, MultiStatus buildStatus, ABuildKind buildKind) {
        if (!this.isBuilderEnabled()) {
            return;
        }
        try {
            builderSet.afterBuildProcess(buildKind);
        }
        catch (Exception e) {
            buildStatus.add((IStatus)new IpsStatus("Error during afterBuildProcess() of the builder set: " + builderSet.getId(), e));
        }
    }

    private void applyBuildCommand(IIpsArtefactBuilderSet currentBuilderSet, MultiStatus buildStatus, BuildCommand command, IProgressMonitor monitor) {
        IIpsArtefactBuilder[] artefactBuilders;
        if (!this.isBuilderEnabled()) {
            return;
        }
        IIpsArtefactBuilder[] iIpsArtefactBuilderArray = artefactBuilders = currentBuilderSet.getArtefactBuilders();
        int n = artefactBuilders.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsArtefactBuilder artefactBuilder = iIpsArtefactBuilderArray[n2];
            try {
                command.build(artefactBuilder, buildStatus);
            }
            catch (Exception e) {
                this.addIpsStatus(artefactBuilder, command, buildStatus, e);
            }
            ++n2;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void addIpsStatus(IIpsArtefactBuilder builder, BuildCommand command, MultiStatus buildStatus, Exception e) {
        String localizedMessage = e.getLocalizedMessage();
        String text = String.valueOf(builder.getName()) + ": Error during: " + command + (IpsStringUtils.isNotBlank((String)localizedMessage) ? ": " + localizedMessage : ".");
        buildStatus.add((IStatus)new IpsStatus(text, e));
    }

    private IDependencyGraph getDependencyGraph(IIpsProject ipsProject) {
        return ipsProject.getDependencyGraph();
    }

    private IIpsProject getIpsProject() {
        if (IIpsModel.get() != null) {
            return IIpsModel.get().getIpsProject(this.builder.getProject());
        }
        return null;
    }

    private void collectIpsSrcFilesForFullBuild(List<IIpsSrcFile> allIpsSrcFiles) {
        IIpsPackageFragmentRoot[] roots;
        IIpsPackageFragmentRoot[] iIpsPackageFragmentRootArray = roots = this.getIpsProject().getIpsPackageFragmentRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsPackageFragmentRoot root = iIpsPackageFragmentRootArray[n2];
            if (root.isBasedOnSourceFolder()) {
                IIpsPackageFragment[] packs;
                IIpsPackageFragment[] iIpsPackageFragmentArray = packs = root.getIpsPackageFragments();
                int n3 = packs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IIpsElement[] elements;
                    IIpsPackageFragment pack = iIpsPackageFragmentArray[n4];
                    IIpsElement[] iIpsElementArray = elements = pack.getChildren();
                    int n5 = elements.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IIpsElement element = iIpsElementArray[n6];
                        if (element instanceof IIpsSrcFile) {
                            allIpsSrcFiles.add((IIpsSrcFile)element);
                        }
                        ++n6;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void removeEmptyFolders() {
        IIpsPackageFragmentRoot[] roots;
        IIpsPackageFragmentRoot[] iIpsPackageFragmentRootArray = roots = this.getIpsProject().getIpsPackageFragmentRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            APackageFragmentRoot artefactDestination;
            IIpsPackageFragmentRoot root = iIpsPackageFragmentRootArray[n2];
            if (root.isBasedOnSourceFolder() && (artefactDestination = root.getArtefactDestination(false)) != null) {
                this.removeEmptyFolders((AFolder)artefactDestination.getResource(), false);
            }
            ++n2;
        }
    }

    private MultiStatus fullBuild(IIpsArtefactBuilderSet ipsArtefactBuilderSet, MultiStatus buildStatus, IProgressMonitor monitor) {
        long begin;
        block11: {
            if (TRACE_BUILDER_TRACE) {
                System.out.println("Full build started.");
            }
            begin = System.currentTimeMillis();
            try {
                try {
                    ArrayList<IIpsSrcFile> allIpsSrcFiles = new ArrayList<IIpsSrcFile>();
                    this.collectIpsSrcFilesForFullBuild(allIpsSrcFiles);
                    monitor.beginTask("full build", 2 * allIpsSrcFiles.size());
                    this.getDependencyGraph(this.getIpsProject()).reInit();
                    monitor.worked(allIpsSrcFiles.size());
                    this.removeEmptyFolders();
                    for (IIpsSrcFile ipsSrcFile : allIpsSrcFiles) {
                        if (!monitor.isCanceled()) {
                            try {
                                monitor.subTask(String.valueOf(Messages.IpsBuilder_building) + ipsSrcFile.getName());
                                this.buildIpsSrcFile(ipsArtefactBuilderSet, this.getIpsProject(), ipsSrcFile, buildStatus, monitor);
                                monitor.worked(1);
                            }
                            catch (Exception e) {
                                buildStatus.add((IStatus)new IpsStatus(e));
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (IpsException e) {
                    buildStatus.add((IStatus)new IpsStatus(e));
                    monitor.done();
                    break block11;
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                throw throwable;
            }
            monitor.done();
        }
        long end = System.currentTimeMillis();
        if (TRACE_BUILDER_TRACE) {
            System.out.println("Full build finished. Duration: " + (end - begin));
        }
        return buildStatus;
    }

    public void clean(IProgressMonitor monitor) {
        IIpsPackageFragmentRoot[] roots;
        this.getIpsProject().clearCaches();
        IIpsPackageFragmentRoot[] iIpsPackageFragmentRootArray = roots = this.getIpsProject().getIpsPackageFragmentRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            APackageFragmentRoot destination;
            IIpsPackageFragmentRoot root = iIpsPackageFragmentRootArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (root.isBasedOnSourceFolder() && (destination = root.getArtefactDestination(true)) != null && destination.exists()) {
                this.removeDerivedResources((AFolder)destination.getResource(), monitor);
            }
            ++n2;
        }
        this.getBuilderSetReInitialisedIfNecessary(this.getIpsProject()).clean(monitor);
    }

    private void removeDerivedResources(AFolder folder, IProgressMonitor monitor) {
        for (AResource member : folder) {
            if (monitor.isCanceled()) {
                return;
            }
            if (!member.exists()) continue;
            if (member.getType() == AResource.AResourceType.FILE && member.isDerived()) {
                member.delete(monitor);
                continue;
            }
            if (member.getType() != AResource.AResourceType.FOLDER) continue;
            AFolder folderMember = (AFolder)member;
            this.removeDerivedResources(folderMember, monitor);
            if (folderMember.getMembers().size() != 0 || !folderMember.isDerived()) continue;
            folderMember.delete(monitor);
        }
    }

    private void removeEmptyFolders(AFolder parent, boolean removeThisParent) {
        if (parent == null || !parent.exists()) {
            return;
        }
        SortedSet members = parent.getMembers();
        if (removeThisParent && members.size() == 0) {
            parent.delete(null);
            return;
        }
        for (AResource member : members) {
            if (member.getType() != AResource.AResourceType.FOLDER) continue;
            this.removeEmptyFolders((AFolder)member, true);
        }
    }

    private void incrementalBuild(IIpsArtefactBuilderSet ipsArtefactBuilderSet, MultiStatus buildStatus, IProgressMonitor monitor) {
        if (TRACE_BUILDER_TRACE) {
            System.out.println("Incremental build started.");
        }
        try {
            try {
                AResourceDelta delta = this.builder.getDelta();
                IncBuildVisitor visitor = new IncBuildVisitor(this.getIpsProject());
                delta.accept((AResourceDeltaVisitor)visitor);
                DependencyResolver dependencyResolver = new DependencyResolver(this.getIpsProject());
                MultiMap<IIpsProject, IDependency> dependenciesForProjectsMap = dependencyResolver.collectDependenciesForIncrementalBuild(visitor.changedAndAddedIpsSrcFiles, visitor.removedIpsSrcFiles);
                int numberOfBuildCandidates = dependenciesForProjectsMap.count() + visitor.removedIpsSrcFiles.size() + visitor.changedAndAddedIpsSrcFiles.size();
                monitor.beginTask("build incremental", numberOfBuildCandidates);
                this.buildRemovedIpsSrcFiles(ipsArtefactBuilderSet, buildStatus, monitor, visitor);
                this.buildChangedAndAddedIpsSrcFiles(ipsArtefactBuilderSet, buildStatus, monitor, visitor);
                this.buildDependeningProjects(buildStatus, monitor, dependenciesForProjectsMap);
            }
            catch (Exception e) {
                buildStatus.add((IStatus)new IpsStatus(e));
                monitor.done();
                if (TRACE_BUILDER_TRACE) {
                    System.out.println("Incremental build finished.");
                }
            }
        }
        finally {
            monitor.done();
            if (TRACE_BUILDER_TRACE) {
                System.out.println("Incremental build finished.");
            }
        }
    }

    private void buildDependeningProjects(MultiStatus buildStatus, IProgressMonitor monitor, MultiMap<IIpsProject, IDependency> dependenciesForProjectsMap) {
        for (IIpsProject ipsProject : dependenciesForProjectsMap.keySet()) {
            MultiStatus currentBuildStatus;
            block13: {
                if (monitor.isCanceled()) break;
                if (!ipsProject.equals(this.getIpsProject()) && !this.checkIpsProjectBeforeBuild(ipsProject)) continue;
                Collection dependencySet = dependenciesForProjectsMap.get((Object)ipsProject);
                IIpsArtefactBuilderSet projectIpsArtefactBuilderSet = this.getBuilderSetReInitialisedIfNecessary(ipsProject);
                HashSet<QualifiedNameType> alreadyBuild = new HashSet<QualifiedNameType>(dependencySet.size());
                currentBuildStatus = this.createInitialMultiStatus();
                try {
                    try {
                        if (!ipsProject.equals(this.getIpsProject())) {
                            this.beforeBuildForBuilderSet(projectIpsArtefactBuilderSet, buildStatus, ABuildKind.INCREMENTAL);
                            this.applyBuildCommand(projectIpsArtefactBuilderSet, currentBuildStatus, new BeforeBuildProcessCommand(ABuildKind.INCREMENTAL, ipsProject), monitor);
                        }
                        this.buildDependencies(monitor, ipsProject, dependencySet, projectIpsArtefactBuilderSet, alreadyBuild, currentBuildStatus);
                    }
                    catch (Exception e) {
                        currentBuildStatus.add((IStatus)new IpsStatus(4, MessageFormat.format(Messages.IpsBuilder_msgExceptionWhileBuildingDependentProjects, ipsProject.getName()), e));
                        if (!ipsProject.equals(this.getIpsProject())) {
                            this.applyBuildCommand(projectIpsArtefactBuilderSet, currentBuildStatus, new AfterBuildProcessCommand(ABuildKind.INCREMENTAL, ipsProject), monitor);
                            this.afterBuildForBuilderSet(projectIpsArtefactBuilderSet, buildStatus, ABuildKind.INCREMENTAL);
                            if (currentBuildStatus.getSeverity() != 0) {
                                ipsProject.reinitializeIpsArtefactBuilderSet();
                            }
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (!ipsProject.equals(this.getIpsProject())) {
                        this.applyBuildCommand(projectIpsArtefactBuilderSet, currentBuildStatus, new AfterBuildProcessCommand(ABuildKind.INCREMENTAL, ipsProject), monitor);
                        this.afterBuildForBuilderSet(projectIpsArtefactBuilderSet, buildStatus, ABuildKind.INCREMENTAL);
                        if (currentBuildStatus.getSeverity() != 0) {
                            ipsProject.reinitializeIpsArtefactBuilderSet();
                        }
                    }
                    throw throwable;
                }
                if (!ipsProject.equals(this.getIpsProject())) {
                    this.applyBuildCommand(projectIpsArtefactBuilderSet, currentBuildStatus, new AfterBuildProcessCommand(ABuildKind.INCREMENTAL, ipsProject), monitor);
                    this.afterBuildForBuilderSet(projectIpsArtefactBuilderSet, buildStatus, ABuildKind.INCREMENTAL);
                    if (currentBuildStatus.getSeverity() != 0) {
                        ipsProject.reinitializeIpsArtefactBuilderSet();
                    }
                }
            }
            if (currentBuildStatus.isOK()) continue;
            buildStatus.add((IStatus)currentBuildStatus);
        }
    }

    private void buildDependencies(IProgressMonitor monitor, IIpsProject ipsProject, Collection<IDependency> dependencySet, IIpsArtefactBuilderSet projectIpsArtefactBuilderSet, Set<QualifiedNameType> alreadyBuild, MultiStatus currentBuildStatus) {
        for (IDependency dependency : dependencySet) {
            if (monitor.isCanceled()) break;
            QualifiedNameType buildCandidateId = dependency.getSource();
            if (alreadyBuild.contains(buildCandidateId)) continue;
            alreadyBuild.add(buildCandidateId);
            IIpsObject ipsObject = ipsProject.findIpsObject(buildCandidateId);
            if (ipsObject == null) continue;
            monitor.subTask(String.valueOf(Messages.IpsBuilder_building) + dependency);
            this.buildIpsSrcFile(projectIpsArtefactBuilderSet, ipsProject, ipsObject.getIpsSrcFile(), currentBuildStatus, monitor);
            this.updateDependencyGraph(ipsObject.getIpsSrcFile());
            monitor.worked(1);
        }
    }

    private void buildChangedAndAddedIpsSrcFiles(IIpsArtefactBuilderSet ipsArtefactBuilderSet, MultiStatus buildStatus, IProgressMonitor monitor, IncBuildVisitor visitor) {
        for (IIpsSrcFile iIpsSrcFile : visitor.changedAndAddedIpsSrcFiles) {
            if (monitor.isCanceled()) break;
            IpsSrcFile ipsSrcFile = (IpsSrcFile)iIpsSrcFile;
            monitor.subTask(String.valueOf(Messages.IpsBuilder_building) + ipsSrcFile.getName());
            this.buildIpsSrcFile(ipsArtefactBuilderSet, this.getIpsProject(), ipsSrcFile, buildStatus, monitor);
            this.updateDependencyGraph(ipsSrcFile);
            monitor.worked(1);
        }
    }

    private void buildRemovedIpsSrcFiles(IIpsArtefactBuilderSet ipsArtefactBuilderSet, MultiStatus buildStatus, IProgressMonitor monitor, IncBuildVisitor visitor) {
        for (IIpsSrcFile iIpsSrcFile : visitor.removedIpsSrcFiles) {
            if (monitor.isCanceled()) break;
            IpsSrcFile ipsSrcFile = (IpsSrcFile)iIpsSrcFile;
            monitor.subTask(String.valueOf(Messages.IpsBuilder_deleting) + ipsSrcFile.getName());
            this.applyBuildCommand(ipsArtefactBuilderSet, buildStatus, new DeleteArtefactBuildCommand(ipsSrcFile), monitor);
            this.updateDependencyGraph(ipsSrcFile);
            monitor.worked(1);
        }
    }

    private void updateMarkers(MultiStatus buildStatus, IIpsObject object, Set<AMarker> xmlValidationMarkers) {
        if (object == null) {
            return;
        }
        AResource resource = object.getEnclosingResource();
        if (!resource.exists()) {
            return;
        }
        try {
            MessageList list = object.validate(object.getIpsProject());
            xmlValidationMarkers.forEach(marker -> list.add(new Message((String)marker.getAttribute("message"), this.getMessageSeverity((AMarker)marker))));
            this.createMarkersFromMessageList(resource, list, PROBLEM_MARKER);
        }
        catch (Exception e) {
            buildStatus.add((IStatus)new IpsStatus("An exception occurred during marker updating for " + object, e));
        }
    }

    public void createMarkersFromMessageList(AResource markedResource, MessageList list, String markerType) {
        LinkedHashSet markers = new LinkedHashSet(markedResource.findMarkers(markerType, true, AResource.AResourceTreeTraversalDepth.RESOURCE_ONLY));
        int i = 0;
        while (i < list.size()) {
            Message msg = list.getMessage(i);
            boolean foundMarked = false;
            Iterator iterator = markers.iterator();
            while (iterator.hasNext()) {
                AMarker marker = (AMarker)iterator.next();
                String message = (String)marker.getAttribute("message");
                Integer severity = (Integer)marker.getAttribute("severity");
                if (!msg.getText().equals(message) || this.getMarkerSeverity(msg) != severity.intValue()) continue;
                foundMarked = true;
                iterator.remove();
                break;
            }
            if (!foundMarked) {
                AMarker marker = markedResource.createMarker(markerType);
                this.updateMarker(marker, msg.getText(), this.getMarkerSeverity(msg));
            }
            ++i;
        }
        for (AMarker marker : markers) {
            marker.delete();
        }
    }

    private void updateMarker(AMarker marker, String text, int severity) {
        marker.setAttributes(new String[]{"message", "severity"}, new Object[]{text, severity});
    }

    private int getMarkerSeverity(Message msg) {
        Severity msgSeverity = msg.getSeverity();
        if (msgSeverity == null) {
            throw new IllegalArgumentException("Unknown severity " + msgSeverity);
        }
        return switch (msgSeverity) {
            case Severity.ERROR -> 2;
            case Severity.WARNING -> 1;
            case Severity.INFO -> 0;
            default -> throw new IllegalArgumentException("Unknown severity " + msgSeverity);
        };
    }

    private Severity getMessageSeverity(AMarker marker) {
        Integer severity = (Integer)marker.getAttribute("severity");
        if (severity == null) {
            throw new IllegalArgumentException("Unknown severity " + severity);
        }
        return switch (severity) {
            case 2 -> Severity.ERROR;
            case 1 -> Severity.WARNING;
            case 0 -> Severity.INFO;
            default -> throw new IllegalArgumentException("Unknown severity " + severity);
        };
    }

    private IIpsObject buildIpsSrcFile(IIpsArtefactBuilderSet ipsArtefactBuilderSet, IIpsProject ipsProject, IIpsSrcFile file, MultiStatus buildStatus, IProgressMonitor monitor) {
        AMarker marker;
        file.getCorrespondingResource().deleteMarkers(PROBLEM_MARKER, false, AResource.AResourceTreeTraversalDepth.RESOURCE_ONLY);
        LinkedHashSet<AMarker> xmlValidationMarkers = new LinkedHashSet<AMarker>();
        for (String xsdError : file.getXsdValidationErrors()) {
            marker = file.getCorrespondingResource().createMarker(PROBLEM_MARKER);
            marker.setAttribute("message", (Object)xsdError);
            marker.setAttribute("severity", (Object)2);
            xmlValidationMarkers.add(marker);
        }
        if (!file.isContentParsable()) {
            AMarker marker2 = file.getCorrespondingResource().createMarker(PROBLEM_MARKER);
            marker2.setAttribute("message", (Object)Messages.IpsBuilder_ipsSrcFileNotParsable);
            marker2.setAttribute("severity", (Object)2);
            return null;
        }
        for (String xsdWarning : file.getXsdValidationWarnings()) {
            marker = file.getCorrespondingResource().createMarker(PROBLEM_MARKER);
            marker.setAttribute("message", (Object)xsdWarning);
            marker.setAttribute("severity", (Object)1);
            xmlValidationMarkers.add(marker);
        }
        IIpsObject ipsObject = file.getIpsObject();
        MultiStatus newStatus = this.createInitialMultiStatus();
        this.applyBuildCommand(ipsArtefactBuilderSet, newStatus, new BuildArtefactBuildCommand(file), monitor);
        if (!newStatus.isOK()) {
            this.fillMultiStatusWithMessageList(newStatus, ipsObject.validate(ipsProject));
            buildStatus.add((IStatus)newStatus);
        }
        this.updateMarkers(buildStatus, ipsObject, xmlValidationMarkers);
        return ipsObject;
    }

    private void fillMultiStatusWithMessageList(MultiStatus status, MessageList list) {
        int i = 0;
        while (i < list.size()) {
            Message msg = list.getMessage(i);
            status.add((IStatus)new IpsStatus(this.getMarkerSeverity(msg), msg.getText(), null));
            ++i;
        }
    }

    private void updateDependencyGraph(IIpsSrcFile ipsSrcFile) {
        this.getDependencyGraph(ipsSrcFile.getIpsProject()).update(ipsSrcFile.getQualifiedNameType());
    }

    private static class AfterBuildProcessCommand
    implements BuildCommand {
        private ABuildKind buildKind;
        private IIpsProject ipsProject;

        public AfterBuildProcessCommand(ABuildKind buildKind, IIpsProject ipsProject) {
            this.buildKind = buildKind;
            this.ipsProject = ipsProject;
        }

        @Override
        public void build(IIpsArtefactBuilder builder, MultiStatus status) {
            if (TRACE_BUILDER_TRACE) {
                System.out.println("AfterBuildProcessCommand, BuilderName: " + (builder != null ? builder.getName() : null) + " , BuilderObjectId: " + System.identityHashCode(builder) + ", Project name: " + (this.ipsProject != null ? this.ipsProject.getName() : null));
            }
            if (builder == null) {
                throw new IpsException((IStatus)new Status(4, "org.faktorips.devtools.model", "Builder is assert to be not null"));
            }
            builder.afterBuildProcess(this.ipsProject, this.buildKind);
        }

        public String toString() {
            return "AfterBuildProcessCmd[kind=" + this.buildKind + "]";
        }
    }

    private static class BeforeBuildProcessCommand
    implements BuildCommand {
        private ABuildKind buildKind;
        private IIpsProject ipsProject;

        public BeforeBuildProcessCommand(ABuildKind buildKind, IIpsProject ipsProject) {
            this.buildKind = buildKind;
            this.ipsProject = ipsProject;
        }

        @Override
        public void build(IIpsArtefactBuilder builder, MultiStatus status) {
            if (TRACE_BUILDER_TRACE) {
                System.out.println("BeforeBuildProcessCommand, BuilderName: " + (builder != null ? builder.getName() : null) + " , BuilderObjectId: " + System.identityHashCode(builder) + ", Project name: " + (this.ipsProject != null ? this.ipsProject.getName() : null));
            }
            if (builder == null) {
                throw new IpsException((IStatus)new Status(4, "org.faktorips.devtools.model", "Builder is assert to be not null"));
            }
            builder.beforeBuildProcess(this.ipsProject, this.buildKind);
        }

        public String toString() {
            return "BeforeBuildProcessCmd[kind=" + this.buildKind + "]";
        }
    }

    private static class BuildArtefactBuildCommand
    implements BuildCommand {
        private IIpsSrcFile ipsSrcFile;

        public BuildArtefactBuildCommand(IIpsSrcFile ipsSrcFile) {
            this.ipsSrcFile = ipsSrcFile;
        }

        @Override
        public void build(IIpsArtefactBuilder builder, MultiStatus status) {
            if (builder.isBuilderFor(this.ipsSrcFile)) {
                long begin = 0L;
                try {
                    if (TRACE_BUILDER_TRACE) {
                        begin = System.currentTimeMillis();
                        System.out.println(String.valueOf(builder.getName()) + ": Start building " + this.ipsSrcFile);
                    }
                    builder.beforeBuild(this.ipsSrcFile, status);
                    builder.build(this.ipsSrcFile);
                }
                finally {
                    builder.afterBuild(this.ipsSrcFile);
                    if (TRACE_BUILDER_TRACE) {
                        System.out.println(String.valueOf(builder.getName()) + ": Finished building " + this.ipsSrcFile + ". Duration: " + (System.currentTimeMillis() - begin));
                    }
                }
            }
        }

        public String toString() {
            return "Build file " + this.ipsSrcFile;
        }
    }

    private static interface BuildCommand {
        public void build(IIpsArtefactBuilder var1, MultiStatus var2) throws IpsException;
    }

    private static class DeleteArtefactBuildCommand
    implements BuildCommand {
        private IIpsSrcFile toDelete;

        public DeleteArtefactBuildCommand(IIpsSrcFile toDelete) {
            this.toDelete = toDelete;
        }

        @Override
        public void build(IIpsArtefactBuilder builder, MultiStatus status) {
            if (builder.isBuilderFor(this.toDelete)) {
                builder.delete(this.toDelete);
            }
        }

        public String toString() {
            return "Delete file " + this.toDelete;
        }
    }

    private static class IncBuildVisitor
    implements AResourceDeltaVisitor {
        private final IIpsSrcFolderEntry[] sourceFolderEntries;
        private List<IIpsSrcFile> removedIpsSrcFiles = new ArrayList<IIpsSrcFile>(100);
        private List<IIpsSrcFile> changedAndAddedIpsSrcFiles = new ArrayList<IIpsSrcFile>(100);

        private IncBuildVisitor(IIpsProject ipsProject) {
            this.sourceFolderEntries = ipsProject.getReadOnlyProperties().getIpsObjectPath().getSourceFolderEntries();
        }

        /*
         * WARNING - void declaration
         */
        public boolean visit(AResourceDelta delta) {
            AResource resource = delta.getResource();
            if (resource == null || resource.getType() == AResource.AResourceType.PROJECT) {
                return true;
            }
            if (!this.isIpsResource(resource)) {
                return false;
            }
            IIpsElement element = IIpsModel.get().getIpsElement(resource);
            IIpsElement iIpsElement = element;
            if (!(iIpsElement instanceof IIpsSrcFile)) {
                return true;
            }
            IIpsSrcFile iIpsSrcFile = (IIpsSrcFile)iIpsElement;
            IIpsSrcFile cfr_ignored_0 = (IIpsSrcFile)iIpsElement;
            switch (delta.getKind()) {
                case ADDED: {
                    void ipsSrcFile;
                    if (element.exists()) {
                        this.changedAndAddedIpsSrcFiles.add((IIpsSrcFile)ipsSrcFile);
                    }
                    return true;
                }
                case REMOVED: {
                    void ipsSrcFile;
                    this.removedIpsSrcFiles.add((IIpsSrcFile)ipsSrcFile);
                    break;
                }
                case CHANGED: {
                    void ipsSrcFile;
                    if (delta.getFlags() == 0 || !element.exists()) break;
                    this.changedAndAddedIpsSrcFiles.add((IIpsSrcFile)ipsSrcFile);
                    return true;
                }
            }
            return true;
        }

        private boolean isIpsResource(AResource resource) {
            Path resourceLocation = resource.getWorkspaceRelativePath();
            IIpsSrcFolderEntry[] iIpsSrcFolderEntryArray = this.sourceFolderEntries;
            int n = this.sourceFolderEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IIpsSrcFolderEntry srcFolderEntry = iIpsSrcFolderEntryArray[n2];
                if (srcFolderEntry.getSourceFolder().getWorkspaceRelativePath().getNameCount() > 1 && srcFolderEntry.getSourceFolder().getWorkspaceRelativePath().startsWith(resourceLocation) || resourceLocation.startsWith(srcFolderEntry.getSourceFolder().getWorkspaceRelativePath())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

