/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.builder;

import java.util.Locale;
import org.faktorips.codegen.JavaCodeFragmentBuilder;
import org.faktorips.datatype.util.LocalizedStringsSet;

public class LocalizedTextHelper {
    private LocalizedStringsSet localizedStringsSet;

    public LocalizedTextHelper(LocalizedStringsSet localizedStringsSet) {
        this.localizedStringsSet = localizedStringsSet;
    }

    public String getLocalizedText(String key, Locale locale) {
        return this.localizedStringsSet.getString(key, locale);
    }

    @Deprecated
    public String getLocalizedToDo(String keyPrefix, JavaCodeFragmentBuilder builder, Locale locale) {
        return this.getLocalizedText(keyPrefix, locale);
    }

    public String getLocalizedToDo(String keyPrefix, Locale locale) {
        return this.getLocalizedToDo(keyPrefix, new Object[0], locale);
    }

    public String getLocalizedToDo(String keyPrefix, Object replacement, Locale locale) {
        return this.getLocalizedToDo(keyPrefix, new Object[]{replacement}, locale);
    }

    public String getLocalizedToDo(String keyPrefix, Object[] replacements, Locale locale) {
        return "// TODO " + this.getLocalizedText(String.valueOf(keyPrefix) + "_TODO", replacements, locale);
    }

    public void appendLocalizedJavaDoc(String keyPrefix, String modelDescription, JavaCodeFragmentBuilder builder, Locale locale) {
        String text = this.getLocalizedText(String.valueOf(keyPrefix) + "_JAVADOC", locale);
        String[] annotations = new String[]{this.getLocalizedText(String.valueOf(keyPrefix) + "_ANNOTATION", locale)};
        StringBuilder sb = new StringBuilder();
        sb.append(text);
        if (modelDescription != null) {
            sb.append(System.lineSeparator()).append(modelDescription);
        }
        builder.javaDoc(sb.toString(), annotations);
    }

    public void appendLocalizedJavaDoc(String keyPrefix, JavaCodeFragmentBuilder builder, Locale locale) {
        this.appendLocalizedJavaDoc(keyPrefix, (String)null, builder, locale);
    }

    public void appendLocalizedJavaDoc(String keyPrefix, Object replacement, String modelDescription, JavaCodeFragmentBuilder builder, Locale locale) {
        String text = this.getLocalizedText(String.valueOf(keyPrefix) + "_JAVADOC", replacement, locale);
        String[] annotations = new String[]{this.getLocalizedText(String.valueOf(keyPrefix) + "_ANNOTATION", locale)};
        StringBuilder sb = new StringBuilder();
        sb.append(text);
        if (modelDescription != null) {
            sb.append(System.lineSeparator()).append(modelDescription);
        }
        builder.javaDoc(sb.toString(), annotations);
    }

    public void appendLocalizedJavaDoc(String keyPrefix, Object replacement, JavaCodeFragmentBuilder builder, Locale locale) {
        this.appendLocalizedJavaDoc(keyPrefix, replacement, null, builder, locale);
    }

    public void appendLocalizedJavaDoc(String keyPrefix, Object[] replacements, String modelDescription, JavaCodeFragmentBuilder builder, Locale locale) {
        String text = this.getLocalizedText(String.valueOf(keyPrefix) + "_JAVADOC", replacements, locale);
        String[] annotations = new String[]{this.getLocalizedText(String.valueOf(keyPrefix) + "_ANNOTATION", locale)};
        StringBuilder sb = new StringBuilder();
        sb.append(text);
        if (modelDescription != null) {
            sb.append(System.lineSeparator()).append(modelDescription);
        }
        builder.javaDoc(sb.toString(), annotations);
    }

    public void appendLocalizedJavaDoc(String keyPrefix, Object[] replacements, JavaCodeFragmentBuilder builder, Locale locale) {
        this.appendLocalizedJavaDoc(keyPrefix, replacements, (String)null, builder, locale);
    }

    public String getLocalizedText(String key, Object replacement, Locale locale) {
        if (this.localizedStringsSet == null) {
            throw new RuntimeException("A LocalizedStringSet has to be set to this builder to be able to call this method.");
        }
        return this.localizedStringsSet.getString(key, locale, new Object[]{replacement});
    }

    public String getLocalizedText(String key, Object[] replacements, Locale locale) {
        return this.localizedStringsSet.getString(key, locale, replacements);
    }
}

