/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.builder;

import java.util.List;
import org.faktorips.devtools.model.ipsproject.IIpsLoggingFrameworkConnector;

@Deprecated(since="21.12")
public class Log4jLoggingFrameworkConnector
implements IIpsLoggingFrameworkConnector {
    public static final String LOG4J_LEVEL_QNAME = "org.apache.log4j.Level";
    public static final String LOG4J_LOGGER_QNAME = "org.apache.log4j.Logger";
    private String id;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    private String build(int level, String loggerInstanceExp, String message, Builder builder) {
        StringBuilder sb = new StringBuilder();
        sb.append(loggerInstanceExp);
        if (40 == level) {
            sb.append(builder.buildTrace(message));
        } else if (level == 0) {
            sb.append(builder.buildDebug(message));
        } else if (10 == level) {
            sb.append(builder.buildInfo(message));
        } else if (20 == level) {
            sb.append(builder.buildWarning(message));
        } else if (30 == level) {
            sb.append(builder.buildError(message));
        } else {
            throw new IllegalArgumentException("The value of the parameter level is not valid. Use the level constants of " + IIpsLoggingFrameworkConnector.class + ".");
        }
        return sb.toString();
    }

    @Override
    public String getLogConditionExp(int level, String loggerInstanceExp, List<String> usedClasses) {
        return this.build(level, loggerInstanceExp, null, new LogConditionExpBuilder(usedClasses));
    }

    @Override
    public String getLogStmtForMessage(int level, String msgConstant, String loggerInstanceExp, List<String> usedClasses) {
        return this.build(level, loggerInstanceExp, msgConstant, new LogStmtForMessageBuilder());
    }

    @Override
    public String getLogStmtForMessageExp(int level, String msgExp, String loggerInstanceExp, List<String> usedClasses) {
        return this.build(level, loggerInstanceExp, msgExp, new LogStmtForMessageExpBuilder());
    }

    @Override
    public String getLogStmtForThrowable(int level, String msgExp, String throwableExp, String loggerInstanceExp, List<String> usedClasses) {
        return this.build(level, loggerInstanceExp, msgExp, new LogStmtForThrowableBuilder(throwableExp));
    }

    @Override
    public String getLoggerClassName() {
        return LOG4J_LOGGER_QNAME;
    }

    @Override
    public String getLoggerInstanceStmt(String scopeExp, List<String> usedClasses) {
        usedClasses.add(this.getLoggerClassName());
        return "Logger.getLogger(" + scopeExp + ")";
    }

    private static interface Builder {
        public String buildInfo(String var1);

        public String buildTrace(String var1);

        public String buildDebug(String var1);

        public String buildWarning(String var1);

        public String buildError(String var1);
    }

    private static class LogConditionExpBuilder
    implements Builder {
        private List<String> usedClasses;

        private LogConditionExpBuilder(List<String> usedClasses) {
            this.usedClasses = usedClasses;
        }

        @Override
        public String buildDebug(String message) {
            return ".isDebugEnabled()";
        }

        @Override
        public String buildError(String message) {
            this.usedClasses.add(Log4jLoggingFrameworkConnector.LOG4J_LEVEL_QNAME);
            return ".isEnabledFor(Level.ERROR)";
        }

        @Override
        public String buildInfo(String message) {
            return ".isInfoEnabled()";
        }

        @Override
        public String buildTrace(String message) {
            return ".isTraceEnabled()";
        }

        @Override
        public String buildWarning(String message) {
            this.usedClasses.add(Log4jLoggingFrameworkConnector.LOG4J_LEVEL_QNAME);
            return ".isEnabledFor(Level.WARN)";
        }
    }

    private static class LogStmtForMessageBuilder
    implements Builder {
        private LogStmtForMessageBuilder() {
        }

        @Override
        public String buildDebug(String message) {
            return ".debug(\"" + message + "\")";
        }

        @Override
        public String buildError(String message) {
            return ".error(\"" + message + "\")";
        }

        @Override
        public String buildInfo(String message) {
            return ".info(\"" + message + "\")";
        }

        @Override
        public String buildTrace(String message) {
            return ".trace(\"" + message + "\")";
        }

        @Override
        public String buildWarning(String message) {
            return ".warn(\"" + message + "\")";
        }
    }

    private static class LogStmtForMessageExpBuilder
    implements Builder {
        private LogStmtForMessageExpBuilder() {
        }

        @Override
        public String buildDebug(String message) {
            return ".debug(" + message + ")";
        }

        @Override
        public String buildError(String message) {
            return ".error(" + message + ")";
        }

        @Override
        public String buildInfo(String message) {
            return ".info(" + message + ")";
        }

        @Override
        public String buildTrace(String message) {
            return ".trace(" + message + ")";
        }

        @Override
        public String buildWarning(String message) {
            return ".warn(" + message + ")";
        }
    }

    private static class LogStmtForThrowableBuilder
    implements Builder {
        private String throwableExp;

        private LogStmtForThrowableBuilder(String throwableExp) {
            this.throwableExp = throwableExp;
        }

        @Override
        public String buildDebug(String message) {
            return ".debug(" + message + ", " + this.throwableExp + ")";
        }

        @Override
        public String buildError(String message) {
            return ".error(" + message + ", " + this.throwableExp + ")";
        }

        @Override
        public String buildInfo(String message) {
            return ".info(" + message + ", " + this.throwableExp + ")";
        }

        @Override
        public String buildTrace(String message) {
            return ".trace(" + message + ", " + this.throwableExp + ")";
        }

        @Override
        public String buildWarning(String message) {
            return ".warn(" + message + ", " + this.throwableExp + ")";
        }
    }
}

