/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.builder.naming;

import org.faktorips.devtools.model.builder.naming.IJavaClassNameProvider;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BuilderAspect {
    IMPLEMENTATION{

        @Override
        public String getJavaClassName(IIpsSrcFile ipsSrcFile, IJavaClassNameProvider javaClassNameProvider) {
            return javaClassNameProvider.getImplClassName(ipsSrcFile);
        }

        @Override
        public boolean isInternalArtifact(IJavaClassNameProvider javaClassNameProvider) {
            return javaClassNameProvider.isImplClassInternalArtifact();
        }
    }
    ,
    INTERFACE{

        @Override
        public String getJavaClassName(IIpsSrcFile ipsSrcFile, IJavaClassNameProvider javaClassNameProvider) {
            return javaClassNameProvider.getInterfaceName(ipsSrcFile);
        }

        @Override
        public boolean isInternalArtifact(IJavaClassNameProvider javaClassNameProvider) {
            return javaClassNameProvider.isInterfaceInternalArtifact();
        }
    };


    public abstract String getJavaClassName(IIpsSrcFile var1, IJavaClassNameProvider var2);

    public abstract boolean isInternalArtifact(IJavaClassNameProvider var1);

    public static BuilderAspect getValue(boolean isInterface) {
        if (isInterface) {
            return INTERFACE;
        }
        return IMPLEMENTATION;
    }
}

