/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.builder.naming;

import org.faktorips.devtools.model.builder.naming.IJavaClassNameProvider;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;

public class DefaultJavaClassNameProvider
implements IJavaClassNameProvider {
    private final boolean isGeneratePublishedInterface;

    public DefaultJavaClassNameProvider(boolean isGeneratePublishedInterface) {
        this.isGeneratePublishedInterface = isGeneratePublishedInterface;
    }

    @Override
    public String getImplClassName(IIpsSrcFile ipsSrcFile) {
        return ipsSrcFile.getIpsProject().getJavaNamingConvention().getImplementationClassName(ipsSrcFile.getIpsObjectName());
    }

    @Override
    public boolean isImplClassInternalArtifact() {
        return this.isGeneratePublishedInterface;
    }

    @Override
    public final String getInterfaceName(IIpsSrcFile ipsSrcFile) {
        if (!this.isGeneratePublishedInterface) {
            return this.getImplClassName(ipsSrcFile);
        }
        return this.getInterfaceNameInternal(ipsSrcFile);
    }

    protected String getInterfaceNameInternal(IIpsSrcFile ipsSrcFile) {
        return ipsSrcFile.getIpsProject().getJavaNamingConvention().getPublishedInterfaceName(ipsSrcFile.getIpsObjectName());
    }

    @Override
    public boolean isInterfaceInternalArtifact() {
        return false;
    }
}

