/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.builder.naming;

import java.nio.file.Path;
import org.faktorips.devtools.model.builder.IJavaPackageStructure;
import org.faktorips.devtools.model.builder.naming.BuilderAspect;
import org.faktorips.devtools.model.builder.naming.IJavaClassNameProvider;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;

public class JavaClassNaming {
    public static final String JAVA_EXTENSION = ".java";
    private final boolean mergableArtifacts;
    private final IJavaPackageStructure javaPackageStructure;

    public JavaClassNaming(IJavaPackageStructure javaPackageStructure, boolean mergableArtifacts) {
        this.javaPackageStructure = javaPackageStructure;
        this.mergableArtifacts = mergableArtifacts;
    }

    public String getQualifiedClassName(IIpsSrcFile ipsSrcFile, BuilderAspect aspect, IJavaClassNameProvider javaClassNameProvider) {
        return this.getQualifiedName(this.getPackageName(ipsSrcFile, aspect, javaClassNameProvider), this.getUnqualifiedClassName(ipsSrcFile, aspect, javaClassNameProvider));
    }

    private String getQualifiedName(String packageName, String className) {
        StringBuilder sb = new StringBuilder();
        if (packageName != null) {
            sb.append(packageName);
            sb.append('.');
        }
        sb.append(className);
        return sb.toString();
    }

    public String getQualifiedClassName(IIpsObject ipsObject, BuilderAspect aspect, IJavaClassNameProvider javaClassNameProvider) {
        if (ipsObject == null) {
            return null;
        }
        return this.getQualifiedClassName(ipsObject.getIpsSrcFile(), aspect, javaClassNameProvider);
    }

    public String getUnqualifiedClassName(IIpsSrcFile ipsSrcFile, BuilderAspect aspect, IJavaClassNameProvider javaClassNameProvider) {
        return aspect.getJavaClassName(ipsSrcFile, javaClassNameProvider);
    }

    public String getPackageName(IIpsSrcFile ipsSrcFile, BuilderAspect aspect, IJavaClassNameProvider javaClassNameProvider) {
        return this.javaPackageStructure.getPackageName(ipsSrcFile, aspect.isInternalArtifact(javaClassNameProvider), this.mergableArtifacts);
    }

    public Path getRelativeJavaFile(IIpsSrcFile ipsSrcFile, BuilderAspect aspect, IJavaClassNameProvider javaClassNameProvider) {
        String name = this.getQualifiedClassName(ipsSrcFile, aspect, javaClassNameProvider);
        int index = name.lastIndexOf(46);
        if (index == name.length()) {
            throw new RuntimeException("The qualified class name is not a valid java class name");
        }
        return Path.of(String.valueOf(name.replace('.', '/')) + JAVA_EXTENSION, new String[0]);
    }
}

