/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.builder.naming;

import org.faktorips.devtools.model.builder.IJavaPackageStructure;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsproject.IIpsSrcFolderEntry;
import org.faktorips.devtools.model.util.QNameUtil;

public class JavaPackageStructure
implements IJavaPackageStructure {
    private static final String INTERNAL_PACKAGE = "internal";

    @Override
    public String getPackageName(IIpsSrcFile ipsSrcFile, boolean internalArtifacts, boolean mergableArtifacts) {
        return this.getPackageNameForGeneratedArtefacts(ipsSrcFile, internalArtifacts, mergableArtifacts);
    }

    @Override
    public String getBasePackageName(IIpsSrcFolderEntry entry, boolean internalArtifacts, boolean mergableArtifacts) {
        String basePackName = mergableArtifacts ? entry.getBasePackageNameForMergableJavaClasses() : entry.getBasePackageNameForDerivedJavaClasses();
        return this.getPackageName(internalArtifacts, basePackName, "");
    }

    protected String getPackageNameForGeneratedArtefacts(IIpsSrcFile ipsSrcFile, boolean internalArtifacts, boolean mergableArtifacts) {
        String basePackName = mergableArtifacts ? ipsSrcFile.getBasePackageNameForMergableArtefacts() : ipsSrcFile.getBasePackageNameForDerivedArtefacts();
        String packageFragName = ipsSrcFile.getIpsPackageFragment().getName().toLowerCase();
        return this.getPackageName(internalArtifacts, basePackName, packageFragName);
    }

    private String getPackageName(boolean internalArtifacts, String basePackName, String packageFragName) {
        if (internalArtifacts) {
            return this.getInternalPackage(basePackName, packageFragName);
        }
        return QNameUtil.concat(basePackName, packageFragName);
    }

    String getInternalPackage(String basePackName, String subPackageFragment) {
        String internalBasePack = QNameUtil.concat(basePackName, INTERNAL_PACKAGE);
        return QNameUtil.concat(internalBasePack, subPackageFragment);
    }
}

