/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.builder.organizeimports;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IpsRemoveImportsOperation {
    private static final String EMPTY = "";
    private static Pattern oneLineCommentsPattern = Pattern.compile("//.*");
    private static Pattern multiLineCommentsPattern = Pattern.compile("/\\*[^\\*][\\s\\S]*?\\*/");
    private static String wordPatternString = "(\\p{Alpha}[\\p{L}0-9_$]*)";
    private static Pattern relevantWordPattern = Pattern.compile("(?<![\\p{L}0-9_$\\.])" + wordPatternString);
    private static Pattern importPattern = Pattern.compile("(?<!\\S) *import\\s[\\.\\s\\p{L}0-9_$]*\\.[\\s]*" + wordPatternString + "[\\s]*; *\\r?\\n?");

    public String removeUnusedAndDuplicateImports(String input) {
        String withoutComments = this.removeComments(input);
        String withoutImports = this.removeImports(withoutComments);
        Set<String> words = this.getRelevantWords(withoutImports);
        return this.removeImports(input, words);
    }

    private String removeImports(String input, Set<String> words) {
        HashSet<String> imports = new HashSet<String>();
        StringBuilder inputWithRemovedImports = new StringBuilder();
        Matcher importMatcher = importPattern.matcher(input);
        int lastEnd = 0;
        while (importMatcher.find()) {
            String importWord;
            inputWithRemovedImports.append(input.substring(lastEnd, importMatcher.start()));
            if (imports.add(importMatcher.group(0)) && words.contains(importWord = importMatcher.group(1))) {
                inputWithRemovedImports.append(input.substring(importMatcher.start(), importMatcher.end()));
            }
            lastEnd = importMatcher.end();
        }
        inputWithRemovedImports.append(input.substring(lastEnd));
        return inputWithRemovedImports.toString();
    }

    private Set<String> getRelevantWords(String input) {
        Matcher matcher = relevantWordPattern.matcher(input);
        HashSet<String> words = new HashSet<String>();
        while (matcher.find()) {
            words.add(matcher.group());
        }
        return words;
    }

    private String removeComments(String input) {
        String removedMultiLineComments = multiLineCommentsPattern.matcher(input).replaceAll(EMPTY);
        return oneLineCommentsPattern.matcher(removedMultiLineComments).replaceAll(EMPTY);
    }

    private String removeImports(String input) {
        Matcher matcher = importPattern.matcher(input);
        return matcher.replaceAll(EMPTY);
    }
}

