/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.dependency;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.faktorips.devtools.model.DependencyType;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.util.MultiMap;

public class SortedByDependency<T extends IIpsObject> {
    private SortedByDependency() {
    }

    public static <T extends IIpsObject> Set<T> sortByInstanceOf(Collection<T> objectsToFix) {
        return new SortedByDependency<T>().sortedFixDifferences(objectsToFix);
    }

    private Set<T> sortedFixDifferences(Collection<T> objectsToFix) {
        MultiMap<T, T> dependencies = this.getDependencyMap(objectsToFix);
        LinkedHashSet result = new LinkedHashSet();
        HashSet roots = new HashSet(dependencies.keySet());
        Collection values = dependencies.values();
        roots.removeAll(values);
        result.addAll(roots);
        this.addChildren(roots, dependencies, result);
        result.addAll(dependencies.keySet());
        return result;
    }

    private MultiMap<T, T> getDependencyMap(Collection<T> objectsToFix) {
        MultiMap dependencies = MultiMap.createWithLinkedSetAsValues();
        HashMap<QualifiedNameType, T> qNameToSrcFile = this.map(objectsToFix);
        for (IIpsObject ipsObject : objectsToFix) {
            IDependency[] dependsOn;
            dependencies.put((Object)ipsObject, (Object[])new IIpsObject[0]);
            IDependency[] iDependencyArray = dependsOn = ipsObject.dependsOn();
            int n = dependsOn.length;
            int n2 = 0;
            while (n2 < n) {
                IIpsObject dependentSrcFile;
                IDependency dependency = iDependencyArray[n2];
                if (dependency.getType().equals((Object)DependencyType.INSTANCEOF) && (dependentSrcFile = (IIpsObject)qNameToSrcFile.get(dependency.getTarget())) != null) {
                    dependencies.put((Object)dependentSrcFile, (Object[])new IIpsObject[]{ipsObject});
                }
                ++n2;
            }
        }
        return dependencies;
    }

    private HashMap<QualifiedNameType, T> map(Collection<T> objectsToFix) {
        HashMap<QualifiedNameType, IIpsObject> map = new HashMap<QualifiedNameType, IIpsObject>();
        for (IIpsObject ipsObject : objectsToFix) {
            map.put(ipsObject.getQualifiedNameType(), ipsObject);
        }
        return map;
    }

    private void addChildren(Collection<T> roots, MultiMap<T, T> dependencies, LinkedHashSet<T> result) {
        for (IIpsObject root : roots) {
            Collection children = dependencies.get((Object)root);
            result.addAll(children);
            this.addChildren(children, dependencies, result);
        }
    }
}

