/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.enums;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.EnumDatatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.datatype.util.DatatypeComparator;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.enums.IEnumAttribute;
import org.faktorips.devtools.model.enums.IEnumAttributeValue;
import org.faktorips.devtools.model.enums.IEnumContent;
import org.faktorips.devtools.model.enums.IEnumType;
import org.faktorips.devtools.model.enums.IEnumValue;
import org.faktorips.devtools.model.enums.IEnumValueContainer;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.runtime.MessageList;
import org.faktorips.util.ArgumentCheck;

public class EnumTypeDatatypeAdapter
implements EnumDatatype {
    private IEnumType enumType;
    private IEnumContent enumContent;
    private IEnumAttribute nameAttribute;

    public EnumTypeDatatypeAdapter(IEnumType enumType, IEnumContent enumContent) {
        ArgumentCheck.notNull((Object)enumType, (Object)this);
        this.enumType = enumType;
        this.enumContent = enumContent;
    }

    public boolean isEnum() {
        return true;
    }

    public String[] getAllValueIds(boolean includeNull) {
        List<String> result = this.findAllIdentifierAttributeValues(includeNull);
        return result.toArray(new String[result.size()]);
    }

    public String getValueName(String id) {
        if (id == null) {
            return null;
        }
        IIpsProject ipsProject = this.getEnumValueContainer().getIpsProject();
        IEnumValue enumValue = this.getEnumValueContainer().findEnumValue(id, ipsProject);
        if (enumValue == null) {
            return null;
        }
        return this.getValueName(ipsProject, enumValue);
    }

    private String getValueName(IIpsProject ipsProject, IEnumValue enumValue) {
        IEnumAttribute displayNameAttribute = this.getNameAttribute(ipsProject);
        IEnumAttributeValue enumAttributeValue = enumValue.getEnumAttributeValue(displayNameAttribute);
        if (enumAttributeValue != null) {
            return IIpsModel.get().getMultiLanguageSupport().getLocalizedContent(enumAttributeValue.getValue(), ipsProject);
        }
        return null;
    }

    private IEnumAttribute getNameAttribute(IIpsProject ipsProject) {
        if (this.nameAttribute == null || !this.nameAttribute.findIsUsedAsNameInFaktorIpsUi(ipsProject)) {
            this.nameAttribute = this.enumType.findUsedAsNameInFaktorIpsUiAttribute(ipsProject);
        }
        return this.nameAttribute;
    }

    public IEnumValue getValue(String value) {
        IIpsProject ipsProject = this.getEnumValueContainer().getIpsProject();
        IEnumValue enumValue = this.getEnumValueContainer().findEnumValue(value, ipsProject);
        if (enumValue == null) {
            return null;
        }
        return enumValue;
    }

    public boolean isSupportingNames() {
        return true;
    }

    private List<String> findAllIdentifierAttributeValues(boolean includesNull) {
        List<String> result = this.getEnumValueContainer().findAllIdentifierAttributeValues(this.getEnumValueContainer().getIpsProject());
        if (includesNull) {
            result.add(null);
        }
        return result;
    }

    private boolean isIdentifierAttributeValues(String value) {
        try {
            return this.getEnumValueContainer().findEnumValue(value, this.getEnumValueContainer().getIpsProject()) != null;
        }
        catch (IpsException e) {
            return false;
        }
    }

    public boolean areValuesEqual(String valueA, String valueB) {
        if (Objects.equals(valueA, valueB)) {
            if (this.isParsable(valueA)) {
                return true;
            }
            throw new IllegalArgumentException("The values seems to be equal but the value " + valueA + " is not parseable by the enum " + this);
        }
        return false;
    }

    public MessageList checkReadyToUse() {
        return new MessageList();
    }

    public int compare(String valueA, String valueB) {
        IIpsProject ipsProject = this.getEnumValueContainer().getIpsProject();
        IEnumValue enumValueA = this.getEnumValueContainer().findEnumValue(valueA, ipsProject);
        IEnumValue enumValueB = this.getEnumValueContainer().findEnumValue(valueB, ipsProject);
        if (enumValueA == null) {
            return enumValueB == null ? 0 : 1;
        }
        if (enumValueB == null) {
            return -1;
        }
        int indexA = this.getEnumValueContainer().getIndexOfEnumValue(enumValueA);
        int indexB = this.getEnumValueContainer().getIndexOfEnumValue(enumValueB);
        return indexA - indexB;
    }

    public String getDefaultValue() {
        return null;
    }

    public ValueDatatype getWrapperType() {
        return null;
    }

    public boolean isImmutable() {
        return !this.isMutable();
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isNull(String value) {
        return value == null;
    }

    public boolean isParsable(String value) {
        return value == null || this.isIdentifierAttributeValues(value);
    }

    public boolean supportsCompare() {
        return true;
    }

    public String getName() {
        return this.enumType.getName();
    }

    public String getQualifiedName() {
        return this.enumType.getQualifiedName();
    }

    public boolean hasNullObject() {
        return false;
    }

    public boolean isAbstract() {
        return this.enumType.isAbstract();
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isValueDatatype() {
        return true;
    }

    public boolean isVoid() {
        return false;
    }

    public int compareTo(Datatype o) {
        return DatatypeComparator.doCompare((Datatype)this, (Datatype)o);
    }

    public IEnumType getEnumType() {
        return this.enumType;
    }

    public IEnumContent getEnumContent() {
        return this.enumContent;
    }

    public IEnumValueContainer getEnumValueContainer() {
        if (this.enumContent == null) {
            return this.enumType;
        }
        return this.enumContent;
    }

    public boolean hasEnumContent() {
        return this.getEnumContent() != null;
    }

    public boolean isCovariant(ValueDatatype datatype) {
        if (datatype instanceof EnumTypeDatatypeAdapter) {
            return this.isCovariant((EnumTypeDatatypeAdapter)datatype);
        }
        return false;
    }

    private boolean isCovariant(EnumTypeDatatypeAdapter datatype) {
        return this.enumType.isSubEnumTypeOrSelf(datatype.enumType, this.enumType.getIpsProject());
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof EnumTypeDatatypeAdapter) {
            void other;
            EnumTypeDatatypeAdapter enumTypeDatatypeAdapter = (EnumTypeDatatypeAdapter)object;
            EnumTypeDatatypeAdapter cfr_ignored_0 = (EnumTypeDatatypeAdapter)object;
            return this.enumType.equals(other.enumType) && this.contentsEqual((EnumTypeDatatypeAdapter)other);
        }
        return super.equals(obj);
    }

    private boolean contentsEqual(EnumTypeDatatypeAdapter other) {
        return Objects.equals(this.enumContent, other.enumContent);
    }

    public int hashCode() {
        return this.enumType.hashCode();
    }

    public String toString() {
        return this.getEnumValueContainer().getQualifiedName();
    }

    public Object getValueByName(String name) {
        IIpsProject ipsProject = this.getEnumValueContainer().getIpsProject();
        return Arrays.stream(this.getAllValueIds(false)).map(this::getValue).filter(v -> Objects.equals(name, this.getValueName(ipsProject, (IEnumValue)v))).findFirst().orElse(null);
    }
}

