/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.extproperties;

import org.faktorips.devtools.model.extproperties.ExtensionPropertyDefinition;
import org.faktorips.devtools.model.util.XmlUtil;
import org.w3c.dom.Element;

public abstract class EnumExtensionPropertyDefinition2<E extends Enum<E>>
extends ExtensionPropertyDefinition {
    private final Class<E> enumType;

    public EnumExtensionPropertyDefinition2(Class<E> enumType) {
        this.enumType = enumType;
    }

    @Override
    public void setDefaultValue(String s) {
        this.defaultValue = Enum.valueOf(this.enumType, s);
    }

    @Override
    public Object getValueFromString(String value) {
        return Enum.valueOf(this.enumType, value);
    }

    @Override
    public Object getValueFromXml(Element valueElement) {
        String content = XmlUtil.getCDATAorTextContent(valueElement);
        if (content == null) {
            return this.defaultValue;
        }
        int qualifiedNameDelimiterPos = content.lastIndexOf(46);
        String id = "";
        id = qualifiedNameDelimiterPos < 0 ? content : content.substring(qualifiedNameDelimiterPos + 1);
        return Enum.valueOf(this.enumType, id);
    }
}

