/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal;

import java.io.IOException;
import java.util.jar.Attributes;
import org.faktorips.devtools.model.IVersion;
import org.faktorips.devtools.model.IVersionProvider;
import org.faktorips.devtools.model.internal.OsgiVersion;
import org.faktorips.devtools.model.internal.OsgiVersionFormat;
import org.faktorips.devtools.model.internal.versionmanager.util.ManifestUtil;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.IVersionFormat;
import org.faktorips.devtools.model.plugin.IpsLog;

public class BundleVersionProvider
implements IVersionProvider<OsgiVersion> {
    private IIpsProject ipsProject;
    private ManifestUtil migrationManifest;
    private final IVersionFormat versionFormat;

    public BundleVersionProvider(IIpsProject ipsProject) throws IOException {
        this.ipsProject = ipsProject;
        this.versionFormat = new OsgiVersionFormat();
        this.initMigrationManifest();
    }

    private void initMigrationManifest() throws IOException {
        this.migrationManifest = ManifestUtil.createMigrationManifestUtil(this.ipsProject);
    }

    @Override
    public boolean isCorrectVersionFormat(String version) {
        return this.versionFormat.isCorrectVersionFormat(version);
    }

    @Override
    public String getVersionFormat() {
        return this.versionFormat.getVersionFormat();
    }

    @Override
    public IVersion<OsgiVersion> getVersion(String versionAsString) {
        return new OsgiVersion(versionAsString);
    }

    @Override
    public IVersion<OsgiVersion> getProjectVersion() {
        Attributes attributes = this.getManifestMainAttributes();
        String value = attributes.getValue("Bundle-Version");
        if (value != null) {
            try {
                return this.getVersion(value);
            }
            catch (IllegalArgumentException e) {
                IpsLog.log(e);
            }
        }
        return OsgiVersion.EMPTY_VERSION;
    }

    @Override
    public void setProjectVersion(IVersion<OsgiVersion> version) {
        try {
            Attributes attributes = this.getManifestMainAttributes();
            attributes.putValue("Bundle-Version", version.asString());
            this.migrationManifest.writeManifest();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected Attributes getManifestMainAttributes() {
        return this.migrationManifest.getManifest().getMainAttributes();
    }
}

