/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.faktorips.devtools.model.ICustomModelExtensions;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.extproperties.IExtensionPropertyDefinition;
import org.faktorips.devtools.model.internal.CustomValidationsResolver;
import org.faktorips.devtools.model.ipsobject.ICustomValidation;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.productcmpt.IProductCmptNamingStrategyFactory;
import org.faktorips.util.ArgumentCheck;

public class CustomModelExtensions
implements ICustomModelExtensions {
    private final Map<Class<?>, List<IExtensionPropertyDefinition>> typeExtensionPropertiesMap;
    private final CustomValidationsResolver customValidationsResolver;
    private final Map<String, IProductCmptNamingStrategyFactory> productCmptNamingStrategies;
    private final IIpsModel ipsModel;

    public CustomModelExtensions(IIpsModel ipsModel) {
        ArgumentCheck.notNull((Object)ipsModel);
        this.ipsModel = ipsModel;
        this.customValidationsResolver = CustomValidationsResolver.createFromExtensions();
        this.typeExtensionPropertiesMap = new ConcurrentHashMap(8, 0.75f, 1);
        this.initExtensionPropertiesFromConfiguration();
        this.productCmptNamingStrategies = new ConcurrentHashMap<String, IProductCmptNamingStrategyFactory>(4, 0.9f, 1);
        this.initProductCmptNamingStrategies();
    }

    private void initProductCmptNamingStrategies() {
        List<IProductCmptNamingStrategyFactory> strategyFactories = IIpsModelExtensions.get().getProductCmptNamingStrategyFactories();
        for (IProductCmptNamingStrategyFactory factory : strategyFactories) {
            this.productCmptNamingStrategies.put(factory.getExtensionId(), factory);
        }
    }

    @Override
    public Set<IExtensionPropertyDefinition> getExtensionPropertyDefinitions(Class<?> type, boolean includeSupertypesAndInterfaces) {
        LinkedHashSet<IExtensionPropertyDefinition> result = new LinkedHashSet<IExtensionPropertyDefinition>();
        this.getIpsObjectExtensionProperties(type, includeSupertypesAndInterfaces, result);
        return result;
    }

    @Override
    public IExtensionPropertyDefinition getExtensionPropertyDefinition(Class<?> type, String propertyId, boolean includeSupertypesAndInterfaces) {
        HashSet<IExtensionPropertyDefinition> props = new HashSet<IExtensionPropertyDefinition>();
        this.getIpsObjectExtensionProperties(type, includeSupertypesAndInterfaces, props);
        for (Object e : props) {
            IExtensionPropertyDefinition prop = (IExtensionPropertyDefinition)e;
            if (!prop.getPropertyId().equals(propertyId)) continue;
            return prop;
        }
        return null;
    }

    @Override
    public Map<String, IExtensionPropertyDefinition> getExtensionPropertyDefinitions(IIpsObjectPartContainer object) {
        HashMap<String, IExtensionPropertyDefinition> result = new HashMap<String, IExtensionPropertyDefinition>();
        for (Class<?> key : this.typeExtensionPropertiesMap.keySet()) {
            if (!key.isAssignableFrom(object.getClass())) continue;
            List<IExtensionPropertyDefinition> propertiesPerClass = this.typeExtensionPropertiesMap.get(key);
            for (IExtensionPropertyDefinition extensionPropertyDefinition : propertiesPerClass) {
                if (!extensionPropertyDefinition.isApplicableFor(object)) continue;
                result.put(extensionPropertyDefinition.getPropertyId(), extensionPropertyDefinition);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    public void addIpsObjectExtensionProperty(IExtensionPropertyDefinition property) {
        List<IExtensionPropertyDefinition> props = this.typeExtensionPropertiesMap.get(property.getExtendedType());
        if (props == null) {
            props = new ArrayList<IExtensionPropertyDefinition>();
            this.typeExtensionPropertiesMap.put(property.getExtendedType(), props);
        }
        props.add(property);
        Collections.sort(props);
    }

    private void getIpsObjectExtensionProperties(Class<?> type, boolean includeSupertypesAndInterfaces, Set<IExtensionPropertyDefinition> result) {
        Class<?>[] interfaces;
        List<IExtensionPropertyDefinition> props = this.typeExtensionPropertiesMap.get(type);
        if (props != null) {
            result.addAll(props);
        }
        if (!includeSupertypesAndInterfaces) {
            return;
        }
        if (type.getSuperclass() != null) {
            this.getIpsObjectExtensionProperties(type.getSuperclass(), true, result);
        }
        Class<?>[] classArray = interfaces = type.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interface1 = classArray[n2];
            this.getIpsObjectExtensionProperties(interface1, true, result);
            ++n2;
        }
    }

    private void initExtensionPropertiesFromConfiguration() {
        this.typeExtensionPropertiesMap.putAll(IIpsModelExtensions.get().getExtensionPropertyDefinitions());
    }

    @Override
    public <T extends IIpsObjectPartContainer> Set<ICustomValidation<?>> getCustomValidations(Class<T> type) {
        return this.customValidationsResolver.getCustomValidations(type);
    }

    public void addCustomValidation(ICustomValidation<? extends IIpsObjectPartContainer> validation) {
        this.ipsModel.clearValidationCache();
        this.customValidationsResolver.addCustomValidation(validation);
    }

    @Override
    public IProductCmptNamingStrategyFactory getProductCmptNamingStrategyFactory(String extensionId) {
        ArgumentCheck.notNull((Object)extensionId);
        return this.productCmptNamingStrategies.get(extensionId);
    }
}

