/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.faktorips.devtools.model.internal.Messages;
import org.faktorips.devtools.model.ipsobject.ICustomValidation;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;

public class CustomValidationsMap {
    private final ConcurrentHashMap<Class<? extends IIpsObjectPartContainer>, Set<ICustomValidation<? extends IIpsObjectPartContainer>>> internalMap = new ConcurrentHashMap();

    public <K extends IIpsObjectPartContainer> Set<ICustomValidation<?>> get(Class<K> key) {
        return new LinkedHashSet(this.getInternal(key));
    }

    private <K extends IIpsObjectPartContainer> Set<ICustomValidation<?>> getInternal(Class<K> key) {
        return this.internalMap.computeIfAbsent(key, $ -> new LinkedHashSet());
    }

    public <K extends IIpsObjectPartContainer> void put(ICustomValidation<K> validation) {
        Class<K> extendedClass = validation.getExtendedClass();
        this.put(extendedClass, validation);
    }

    public <K extends IIpsObjectPartContainer> void put(Class<K> key, ICustomValidation<?> validation) {
        this.putWithRuntimeCheck(key, validation);
    }

    private <T extends IIpsObjectPartContainer> void putWithRuntimeCheck(Class<? extends T> key, ICustomValidation<?> validation) {
        if (!validation.getExtendedClass().isAssignableFrom(key)) {
            String message = Messages.CustomValidationsMap_MsgCannotAddValidation_classesDoNotMatch;
            throw new RuntimeException(MessageFormat.format(message, validation, validation.getExtendedClass(), key));
        }
        this.putInternal(key, validation);
    }

    private <K extends IIpsObjectPartContainer> void putInternal(Class<K> key, ICustomValidation<?> validation) {
        Set<ICustomValidation<?>> set = this.getInternal(key);
        set.add(validation);
    }

    public <K extends IIpsObjectPartContainer> void putAll(Class<K> key, Collection<ICustomValidation<? extends IIpsObjectPartContainer>> validations) {
        for (ICustomValidation<? extends IIpsObjectPartContainer> customValidation : validations) {
            this.put(key, customValidation);
        }
    }

    public boolean isEmpty() {
        return this.valuesInternal().isEmpty();
    }

    private Set<ICustomValidation<? extends IIpsObjectPartContainer>> valuesInternal() {
        LinkedHashSet<ICustomValidation<? extends IIpsObjectPartContainer>> result = new LinkedHashSet<ICustomValidation<? extends IIpsObjectPartContainer>>();
        for (Set<ICustomValidation<? extends IIpsObjectPartContainer>> list : this.internalMap.values()) {
            result.addAll(list);
        }
        return result;
    }

    public <K extends IIpsObjectPartContainer> boolean containsValidationsFor(Class<K> key) {
        return !this.get(key).isEmpty();
    }

    public Set<Class<? extends IIpsObjectPartContainer>> getKeys() {
        return this.internalMap.keySet();
    }

    public void clear() {
        this.internalMap.clear();
    }
}

