/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.internal.CustomValidationsMap;
import org.faktorips.devtools.model.ipsobject.ICustomValidation;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;

public class CustomValidationsResolver {
    private CustomValidationsMap backingMap = new CustomValidationsMap();
    private CustomValidationsMap resolvedMap = new CustomValidationsMap();
    private Set<Class<? extends IIpsObjectPartContainer>> resolvedTypes = new LinkedHashSet<Class<? extends IIpsObjectPartContainer>>();

    public <T extends IIpsObjectPartContainer> Set<ICustomValidation<?>> getCustomValidations(Class<T> type) {
        if (!this.isResolved(type).booleanValue()) {
            this.resolveCustomValidationsForClassHierarchy(type);
        }
        return this.resolvedMap.get(type);
    }

    private <T> Boolean isResolved(Class<T> type) {
        return this.resolvedTypes.contains(type);
    }

    protected <T extends IIpsObjectPartContainer> void resolveCustomValidationsForClassHierarchy(Class<T> type) {
        List<ICustomValidation<? extends IIpsObjectPartContainer>> validations = this.resolveAllCustomValidationsFor(type);
        this.resolvedMap.putAll(type, validations);
        this.markAsResolved(type);
    }

    private <T extends IIpsObjectPartContainer> List<ICustomValidation<?>> resolveAllCustomValidationsFor(Class<T> type) {
        ArrayList validations = new ArrayList();
        this.collectCustomValidations(type, validations);
        return validations;
    }

    private <T extends IIpsObjectPartContainer> void collectCustomValidations(Class<T> type, List<ICustomValidation<?>> validations) {
        this.collectValidationsForSameType(type, validations);
        this.collectValidationsForSuperclass(type, validations);
        this.collectValidationsForImplementedInterfaces(type, validations);
    }

    private <T extends IIpsObjectPartContainer> void collectValidationsForSameType(Class<T> type, List<ICustomValidation<?>> validations) {
        Set<ICustomValidation<?>> typeValidations = this.backingMap.get(type);
        if (typeValidations != null) {
            validations.addAll(typeValidations);
        }
    }

    private <T extends IIpsObjectPartContainer> void collectValidationsForImplementedInterfaces(Class<T> type, List<ICustomValidation<?>> validations) {
        Class<?>[] interfaces;
        Class<?>[] classArray = interfaces = type.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interface1 = classArray[n2];
            if (IIpsObjectPartContainer.class.isAssignableFrom(interface1)) {
                Class<?> implementedInterface = interface1;
                this.collectCustomValidations(implementedInterface, validations);
            }
            ++n2;
        }
    }

    private <T extends IIpsObjectPartContainer> void collectValidationsForSuperclass(Class<T> type, List<ICustomValidation<?>> validations) {
        if (type.getSuperclass() != null && IIpsObjectPartContainer.class.isAssignableFrom(type.getSuperclass())) {
            Class<T> superclass = type.getSuperclass();
            this.collectCustomValidations(superclass, validations);
        }
    }

    private <T extends IIpsObjectPartContainer> void markAsResolved(Class<T> type) {
        this.resolvedTypes.add(type);
    }

    public <T extends IIpsObjectPartContainer> void addCustomValidation(ICustomValidation<T> validation) {
        this.addInternal(validation);
        this.clearCache();
    }

    private <T extends IIpsObjectPartContainer> void addInternal(ICustomValidation<T> validation) {
        this.backingMap.put(validation);
    }

    private void clearCache() {
        this.resolvedMap.clear();
        this.resolvedTypes.clear();
    }

    public static <T extends IIpsObjectPartContainer> CustomValidationsResolver createFromExtensions() {
        List<ICustomValidation<?>> customValidations = IIpsModelExtensions.get().getCustomValidations();
        return CustomValidationsResolver.createFromList(customValidations);
    }

    public static <T extends IIpsObjectPartContainer> CustomValidationsResolver createFromList(List<ICustomValidation<?>> allValidations) {
        CustomValidationsResolver customValidationsPerType = new CustomValidationsResolver();
        for (ICustomValidation<?> validation : allValidations) {
            customValidationsPerType.addCustomValidation(validation);
        }
        return customValidationsPerType;
    }
}

